// -*- Mode: C++ -*-
// Copyright (C) 2005 Aldo Nicolas Bruno

/*
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/



#ifndef __NYCOLAS_HTTP_RESPONSE_H__
#define __NYCOLAS_HTTP_RESPONSE_H__
#include "connectionbuffer.h"
#include "object.h"

class HTTPResponse:public virtual Object
{
  HTTPResponse(){};

  HTTPRequest * request;
  HTTPConnection* connection;
  HTTPResponseHeader *rh;
  HTTPServer *server;
  long int errornum;

  ConnectionBuffer write;  
  void ** data;

public:
  HTTPResponse(HTTPConnection* c,HTTPServer *s);
  ~HTTPResponse(){};

  int fromerror(long nerror, const xstring& optdesc="");
  int fromrequest(HTTPRequest* r);
 
  long geterrornumber() const;
  void addheader(const xstring& name, const xstring& value );
  void setstatus(long code, const xstring& desc);
  
  //protected:
  int sendstatus(long nstatus, const xstring& optdesc="");
  int sendheader(const xstring& name, const xstring& value);
  int sendserverheaders();
  int sendresponse(HTTPRequest * req,  const xstring &headers, const  xstring& msg);

  int preparebufferized(__int64_t size);
  int sendbufferized( const xstring& s );
};

#endif // __NYCOLAS_HTTP_RESPONSE_H__
