// -*- Mode: C++ -*-
// Copyright (C) 2004-2005 Aldo Nicolas Bruno

/*
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/


#include <sys/types.h>
#include <regex.h>
#include <stdlib.h>

#include "httpserver.h"
#include "httpconnection.h"

#include "httpheader.h"
#include "httpgetparamlist.h"
#include "httpresponseheader.h"
#include "httprequestheader.h"
#include "httprequest.h"
#include "httpresponse.h"
#include "httpresource.h"
#include "httpresourcefile.h"
#include "statuscodes.h"
#include "syntax.h"

HTTPResponse::HTTPResponse(HTTPConnection *c,HTTPServer *s)
  : Object("HTTPResponse"), connection(c),errornum(0), write(c,NHBUFFERLEN)
{
  server = s;
  this->data=data;
}


int HTTPResponse::fromrequest(HTTPRequest *r)
{
  if (! r ) return -1;
  if (r->getcmd() == "GET"||r->getcmd()=="HEAD"||r->getcmd()=="POST")
    {
      httpresourcemap *p=server->getfirstres();
      long ok=0;

      for (;p; p=p->next)
	{
	  //if (p->name==r->getres())
	  int x=p->res->checkres(r->getres());
	  if (x>0)
	    {
#ifdef DEBUG
	      cout <<  "HTTPResponse: found embedded resource " << p->name << "\n";
#endif
	      //			  HTTPResourceInstance *t = new HTTPResourceInstance(p->res,r,this);
	      p->res->prepareresponse(r,this);
		  
	      int r= p->res->response ();

	      return r;
			  
	      //ok=1;
	      //break;
	    }
	  else // if resource name was not recognized by the resource itself,
	    // maybe the resource locator was specified manually,
	    // or maybe the resource does not support own locator recognition at all
	    // so the locator must be specified manually (such as with httpredirectresource)
			
	    {
	      if (p->name==r->getres())
		{
#ifdef DEBUG
		  cout << "HTTPResponse: found embedded resource " 
		       << p->name << " as explicit\n";
#endif
		  p->res->prepareresponse(r,this);
		  int r = p->res->response();
		  return r;
		  //ok=1;
		  //break;
		}
	    }
	}
      
      if (!ok) // if not embedded resources found, try to open a local file in the docroot
	{
	  HTTPResourceFile f(r->getserver());
	  f.prepareresponse(r,this);
	  int r=f.response();
	  return r;
		  
	  // fromerror(404); // Not Found  
	}
    }
  else
    {
      fromerror(501); // 501-not implemented
      return -1; // disconnect
    }
  return 0;
}

int HTTPResponse::fromerror(long nerror, const xstring & optdesc)
{
  if(sendstatus(nerror,optdesc)<0) return -1;
  xstring msg;
  if (nerror==404)
    {
      msg="<html><title>404 - Page Not Found</body><body>The page that you requested cannot be found";
      if (optdesc!="") msg +=": " + optdesc;
      msg+="</body></html>" CRLF;
    
      xstring header;
      header = "Content-Type: text/html" CRLF 
	// "Connection: Close" CRLF
	;
      sendresponse(NULL,header,msg);
    }
  else
    {
      sendresponse(NULL,
		   "Connection: Close" CRLF,
		   ""
		   );
    }
  return 0;
}

int HTTPResponse::sendstatus(long nstatus, const xstring& optdesc)
{
  xstring s;
  for (int i=0; statuscodes[i].number; ++i)
    {
      if (statuscodes[i].number==nstatus)
	{
	  s = "HTTP/1.1 " + xstring::fromlong(nstatus) + " " + statuscodes[i].description + CRLF;
	  write << s;
	  return write.status();
	}
    }

  s = "HTTP/1.1 " + xstring::fromlong(nstatus) + " " + optdesc + CRLF;
  write << s;
  return write.status();
}

int HTTPResponse::sendheader(const xstring& name, const xstring& value)
{
  xstring x;
  x = name + ": " + value + CRLF;
  
  write << x;
  return write.status();
}

int HTTPResponse::sendserverheaders()
{
  xstring h;
  HTTPTime t(time(NULL));
  h = "Date: " + t.get_rfc1123() + CRLF 
    + "Server: " SERVERSTRING CRLF ;

  write << h;
  return write.status();
}

int HTTPResponse::preparebufferized(__int64_t size)
{
  sendstatus(200); // OK
  sendserverheaders();
  
  char szstr[1024];
  sprintf(szstr,"%lld",size);
  sendheader ( "Content-Length", szstr );
  write << CRLF;
  return write.status();
}

int HTTPResponse::sendbufferized( const xstring& s )
{
  write << s;
  return write.status();
}

int HTTPResponse::sendresponse(HTTPRequest * req, const xstring &headers,  const xstring& msg)
{
  if(sendserverheaders()<0) return -1;
  write << headers;
  
  xstring h = "Content-Length: " 
    + xstring::fromlong(msg.length())
    + CRLF CRLF ;

  write << h;
  
  if(req && req->getcmd()=="HEAD") 
    { }
  else
    write << msg;

  write.flush();

  return write.status(); // success
}
