// -*- Mode: C++ -*-
// Copyright (C) 2004 Aldo Nicolas Bruno

/*
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include <limits.h>
#include <cstdlib>

#include <xstring.h>



#include "httpserver.h"
#include "httpconnection.h"
#include "httpheader.h"
#include "httprequestheader.h"
#include "httpgetparamlist.h"
#include "httprequest.h"
#include "httpresponseheader.h"

#include "httpresponse.h"
#include "httpserver.h"

#include "httpresource.h"
#include "httpresourcefile.h"
#include "statuscodes.h"
#include "syntax.h"

HTTPResourceFile::HTTPResourceFile(HTTPServer *srvr)
  :  HTTPResource(srvr)
{
  server=srvr;
}
#define _STRPATHSEP "/"
#define _CHRPATHSEP '/'

#if 0
// correct path from something like /a/../b in /b and /../../../a in /a
// TODOOO!!!!
xstring correct_path(const xstring& s)
{
  long i,l=s.length();
  xstring r(l);
  xstring ** z=s.splitc(_CHRPATHSEP); 
  long li=0;

  while(z&&z[li++]); // count items

  int n=0; o=0;
  for(i=0;i<li;++i)
    {
      if(!z[i]) continue;
      if(*z[i]=="..")
	{
	  delete z[i];
	  z[i]=0;
	  i--;
	}
      else if(*z[i]!=".")n++;
      
    }
}
#endif 

int HTTPResourceFile::response()
{
  fprintf(stdout,"on resourcefile::response()\n");
  int f;
  xstring file=server->getdocroot();
  file+=req->getres();

  char buff_rpath[PATH_MAX+5];
  char buff_drrpath[PATH_MAX+5];

  char* rp=realpath(file.text(),buff_rpath);
  char* drrp=realpath(server->getdocroot().text(),buff_drrpath);

#ifdef DEBUG  
  fprintf(stdout,"rp:%s drrp:%s\n",rp,drrp);
#endif

  if(!rp||!drrp||strncmp(rp,drrp,strlen(drrp))!=0)
    {
      fprintf (stdout,"Resource would be outside of the docroot!!\n");
      resp->fromerror(404); // Send Not Found to confuse the attacker...
      return 0;
    }

  f=open64 ( rp , O_RDONLY|O_LARGEFILE);

  if( f<0)
    {
      perror("Error in HTTPResourceFile::process file not found!!!");
      resp->fromerror(404); // not found
      return 0;
    }

  struct stat64 st;
  int r=fstat64(f,&st);
  if (r<0)
    {
      close(f);
      perror("Error in HTTPResourceFile::process in stat()");
      resp->fromerror(500); //internal server error
      return -1;
    }
  if(S_ISDIR(st.st_mode))
    {
      close(f);
      fprintf (stdout,"Resource is a directory!!\n");
      resp->fromerror(403,"Resource is a directory"); // Forbidden
      return -1;
    }

  __int64_t l=st.st_size; // file size in bytes
  
  resp->preparebufferized ( l );

  if(req->getcmd()=="HEAD") return 0;
  
  r=0;
  xstring buff(NHBUFFERLEN+100);
  buff.setbinary(true);
  char *b=buff.getbuffer();

  while (1)
    {
      r=read(f,b,NHBUFFERLEN); // todo make config entry for this!!
      if ( r==0 ) break;
      if ( r < 0 )
	{
	  perror("Error in HTTPResourceFile::process in read()");
	  close(f);
	  return -1; // fatal!! disconnect!!
	}

      buff.setlength(r);
      if (resp->sendbufferized(buff)<0)
	{
	  perror("Error in HTTPResourceFile::process in send()");
	  close (f);
	  return -1; // fatal!!
	}
    }
  
  close(f);
  return 0;
}

HTTPResourceFile::~HTTPResourceFile()
{

}
