// -*- Mode: C++ -*-
// Copyright (C) 2004 Aldo Nicolas Bruno

/*
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include <xstring.h>

#include "httpserver.h"
#include "httpconnection.h"
#include "httpheader.h"
#include "httprequestheader.h"
#include "httpgetparamlist.h"

#include "httprequest.h"
#include "httpresponseheader.h"
#include "httpresponse.h"
#include "httpserver.h"

#include "httpresource.h"
#include "statuscodes.h"

HTTPResource::HTTPResource(HTTPServer *srvr)
  :Object("HTTPResource")
{
  server=srvr;
  //  conn=0; //NULL;
  resp=0; // NULL;
  req=0; //NULL;
}

int HTTPResource::response()
{
  return -1;
}

HTTPResource::~HTTPResource()
{

}

int HTTPResource::prepareresponse( HTTPRequest* req, HTTPResponse *resp)
{
  // this->conn=c;
  this->req=req;
  this->resp=resp;
  return 0;
}

// return >0 for accept, 0 for not match, <0 for not supported, that means that the resource must be specified manually
int HTTPResource::checkres(const xstring& abspath) const
{
  return -1;
}
