// -*- Mode: C++ -*-
// Copyright (C) 2005 Aldo Nicolas Bruno

/*
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef __NYCOLAS_HTTP_REQUEST_HEADER_H__
#define __NYCOLAS_HTTP_REQUEST_HEADER_H__

#ifndef __NYCOLAS_HTTP_HEADER_H__
#include "httpheader.h"
#endif

#include <sys/types.h>

#include <regex.h>

class HTTPRequestHeader :  public virtual HTTPHeader
{
  xstring buff;
  xstringlist hl;
  xstringlistitem* last;

  regex_t headerregex;
  int regex_stat;
  regex_t requestlineregex;
  regex_t statuslineregex;

  xstringvector endoftoken;
  int status;
public:
  enum {
    Complete=0, 
    NotComplete,
    Idle,
    Error
  };

  HTTPRequestHeader (HTTPConnection * c);
  ~HTTPRequestHeader();

  int readline (xstring & read, bool blocking=false) ;
  bool validateline(const xstring& s);
  int readstartline(xstring & startline, int check=0, bool blocking = true);
  int sched (bool blocking = false );

  int readandprocessheader ();
  
  enum 
    {
      CHECK_REQUESTLINE=1,
      CHECK_STATUSLINE=2
    };
};

#endif // __NYCOLAS_HTTP_REQUEST_HEADER_H__


