// -*- Mode: C++ -*-
// Copyright (C) 2005 Aldo Nicolas Bruno

/*
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/



#ifndef __NYCOLAS_HTTP_REQUEST_H__
#define __NYCOLAS_HTTP_REQUEST_H__

#include "httptime.h"
#include "httpcookie.h"
#include "object.h"

class HTTPRequest : public virtual Object
{
  HTTPRequest(){};

  xstring cmd, fullres,res, host, version;
  HTTPRequestHeader* header;
  HTTPServer * server;
  HTTPConnection* conn;
  xstring message;
  xstring postdata;
  long int errornum;
  HTTPTime time;
  HTTPGETParamList* params;
  HTTPCookie* cookies;

 public:
  HTTPRequest(HTTPConnection* c,HTTPServer *s);
  ~HTTPRequest();
  
  HTTPServer* getserver(){return server;}

  void updateparams();
  int process( const xstring& startline, HTTPRequestHeader *h);
  
  xstring getcmd() const;
  xstring getres() const;
  xstring gethost() const;
  xstring getversion() const;
  HTTPTime gettime() const;
  HTTPRequestHeader * getheaders();
  const xstring& getmessage() const;
  int checkversion(const xstring& versionstring);

  xstring getparam(const xstring& name) const;
  xstring getcookie(const xstring&) const;
  xstring geterrornumber() const; //????
  
  int readpostdata();
  const xstring& getpostdata() const;

};

#endif // __NYCOLAS_HTTP_REQUEST_H__
