// -*- Mode: C++ -*-
// Copyright (C) 2004 Aldo Nicolas Bruno

/*
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "httpserver.h"

#include "httpconnection.h"
#include "httpheader.h"
#include "httprequestheader.h"
#include "httptime.h"
#include "httpgetparamlist.h"
#include "httprequest.h"


HTTPRequest::HTTPRequest(HTTPConnection *c,HTTPServer *s)
  : Object("HTTPRequest")
{
  //  initialize (data);
  server=s;
  conn=c;
  params=0; header=0;//NULL
  cookies=0;
}

// ;-)
#define MINABC(a,b,c) ((a)<(b)?((a)<(c)?(a):(c)):(b)<(c)?(b):(c))

HTTPRequest::~HTTPRequest()
{
  if (params) delete params;
  if (cookies) delete cookies;
}

xstring HTTPRequest::getcmd() const
{
  return cmd;
} 

xstring HTTPRequest::getres() const
{
  return res;
} 

xstring HTTPRequest::getcookie(const xstring& name) const
{
  return cookies?cookies->getitem(name):"";
}

void HTTPRequest::updateparams()
{
  if(params) 
    {
      delete params;
      params=0;
    }
  // process get parameters  
  xstringvector y = fullres.splitc('?',1);
  
  if (y.n()>0)
    {
      res=HTTPGETParamList::unescape_request(y[0]);
      if(y.n()>1)
	{
	   params=new HTTPGETParamList;
	   params->process(y[1]);
	}
      else
	params=0; //NULL
    }
  else
    {
      res=HTTPGETParamList::unescape_request(fullres);
      params=0;
    }
}

int HTTPRequest::checkversion(const xstring& versionstring)
{
 
  // Version string: H T T P / X ...  .  ...  X     X     ...
  //                 0 1 2 3 4 5 ... psx     psx+1 psx+2  ...

  long psx=versionstring.search('.');
  if (psx<0) return -1;
  
  long maj=versionstring.mid(5,psx-5).getint();
  long min=versionstring.mid(psx+1,versionstring.length()-psx-1).getint();

  if (maj!=1)
    {
      cout <<  "HTTPRequest::process(): HTTP version not supported: " << versionstring << endl;
      return -1;
    }
  fprintf (stdout,"HTTP version: %d.%d\n", maj,min);

  return 0;
}

int HTTPRequest::process(const xstring& requestline, HTTPRequestHeader* h )
{  
  long r=-1;
  
  header=h;

  xstringvector v = requestline.splitc(0x20);

  if ( v.n()<3 ) return -1;

  xstring xcmd=v[0];
  xstring xreq=v[1];
  xstring xver=v[2];
  
  if(checkversion(xver)<0)
    return -1;

  version=xver;
  cmd=xcmd;
  fullres=xreq;
  host=header->getitem("Host");
  time.fromstring(header->getitem("Date"));
  //errornum=;
 
  updateparams();

  xstring k=header->getitem("Cookie");  
  if(!k.isempty())
    cookies=new HTTPCookie(k);

  postdata="";

  return 0;
}

xstring HTTPRequest::getversion() const
{
  return version;
}

HTTPTime HTTPRequest::gettime() const
{
  return time;
}

xstring HTTPRequest::getparam(const xstring& name) const
{
  if(params)
    return params->getitem(name);
  else
    return "";
}

HTTPRequestHeader* HTTPRequest::getheaders()
{
  return header;
}

int HTTPRequest::readpostdata()
{
  if(getcmd()=="POST") 
    {
      long l = header->getitem("Content-Length").getlong();
      if(l>0)
	{
	  postdata= conn->popn(l);
#ifdef DEBUG
	  cout << "<POSTDATA>" << postdata << "</POSTDATA>\n";
#endif
	  if(postdata.isempty())
	    return -1;
	  return 0;
	}
    }
  return 0;
}

const xstring& HTTPRequest::getpostdata() const
{
  return postdata;
}
