// -*- Mode: C++ -*-
// Copyright (C) 2004 Aldo Nicolas Bruno

/*
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include <xstring.h>

#include "httpserver.h"
#include "httpconnection.h"
#include "httpheader.h"
#include "httprequestheader.h"
#include "httpgetparamlist.h"

#include "httprequest.h"
#include "httpresponseheader.h"
#include "httpresponse.h"
#include "httpserver.h"

#include "httpresource.h"
#include "httpredirectresource.h"
#include "statuscodes.h"
#include "syntax.h"

HTTPRedirectResource::HTTPRedirectResource(HTTPServer *srvr,const xstring& where)
  :HTTPResource(srvr)
{
  server=srvr;
  w=where;
  //  fprintf(stdout,"where=%s\n",w.text());
}

int HTTPRedirectResource::response()
{
  resp->sendstatus(301); // Moved permanently
  xstring head;
  xstring x;
  if(req->getheaders()) x=req->getheaders()->getitem("host");
  else x=server?server->gethostname()+":"+xstring::fromint(server->getport()):"";
  
  head = 
    "Content-Type: text/html" CRLF
    "Location: http://" CRLF
    + x + w;
  
  resp->sendresponse(NULL,head,"");
  
  return 0;
}

HTTPRedirectResource::~HTTPRedirectResource()
{

}
