// -*- Mode: C++ -*-
// Copyright (C) 2004-2005 Aldo Nicolas Bruno

/*
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef __HTTP_INTERNAL_PROXY_H__

#define __HTTP_INTERNAL_PROXY_H__

//#include "inputconn.h"
//#include "worker.h"
//#include "httpserver.h"
#include "schedendpointlist.h"

class HTTPInternalProxy
{
  SchedEndpointList inputconns;
  SchedEndpointList workers;
  
  HTTPServer * server;
  ServerSocket *listener;
  int n;
  fd_set rset,wset,eset;
  
public:
  HTTPInternalProxy(HTTPServer *s,int n=4);

  int run();

  int addworker();
  int acceptconnection();
  int wait4traffic();
  int sched();
  
  Worker* getidle();
  int createinputconn(Socket * s);
  
  int destroyinputconn(InputConn* ic);
  int destroyworker(Worker* w);

};


#endif

