// -*- Mode: C++ -*-
// Copyright (C) 2004-2005 Aldo Nicolas Bruno

/*
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include <sys/types.h>
#include <sys/wait.h>

#include <errno.h>
#include <signal.h>
#include <stdio.h>
#include <string.h>
#include <pthread.h>
#include <unistd.h>
#include <limits.h>
#include <sys/mman.h>
#include <sys/types.h>
#include <sys/wait.h>

#include <errno.h>
#include <signal.h>
#include <stdio.h>
#include <string.h>
#include <pthread.h>
#include <unistd.h>
#include <limits.h>
#include <sys/mman.h>


#include "httpserver.h"
#include "httpconnection.h"
#include "httpservertoken.h"
#include "httprequestheader.h"
#include "httpgetparamlist.h"
#include "httpresponseheader.h"
#include "httprequest.h"
#include "httpresponse.h"

#include "inputconn.h"
#include "worker.h"
#include "schedendpointlist.h"
#include "httpinternalproxy.h"
#include "common.h"



volatile static int killed=0;

static void int_handler(int n)
{
  killed++;
  if(killed)//>2)
    {
      //      signal (SIGINT,0);
      exit(1);
    }
  if(killed>1)
    {
      cout << "S: Signal already caught. Maybe not all connections have finished." << endl;
      cout << "S: Try again to force exit" << endl;
    }
  else
    {
      cout << "S: Caught signal " <<  n << "."<< endl;
      cout << "S: No more connections will be accepted." << endl;
    }
  //  signal(SIGINT,int_handler);
}

static void sigchld(int signl)
{  
  int status;
  pid_t pid;
  int xxerrno=errno;
  
  signal (SIGCHLD,sigchld);
  
  while (1)
    {
      pid=waitpid(-1,&status,WNOHANG);
      if(!pid) break;
      if(pid<0)
	{
	  if ( errno == EINTR || errno == EAGAIN )
		continue;
	  break;
	}
    }
  errno=xxerrno;
}


HTTPInternalProxy::HTTPInternalProxy(HTTPServer* s,int n)
{
  FD_ZERO(&rset);
  FD_ZERO(&wset);
  FD_ZERO(&eset);
  this->n=n;
  server=s;
  listener=s->getsocket();
}

int HTTPInternalProxy::run()
{
  signal (SIGPIPE, SIG_IGN);
  signal (SIGINT,int_handler);
  signal (SIGCHLD,sigchld);

  if (n<1) n=4; // default

  int s=0;

  for (int i=0; i<n ; ++i)
    {
      s=addworker();
    }
  if (s<0)
    
      return s;

  int l;
  while ( 1 )
    {
      l=wait4traffic();

      if (l<=0)
	{
	  if (errno==EINTR)
	    continue;

	  perror("HTTPInternalProxy::run(): scheduler loop: select()");
	  return -1;
	}
      sched();
      //   sleep(1);
    }
}

int HTTPInternalProxy::wait4traffic()
{
  FD_ZERO(&rset);
  FD_ZERO(&wset);
  FD_ZERO(&eset);

  int gfdw= workers.setfdset(&rset,&wset,&eset);
  int gfdc= inputconns.setfdset(&rset,&wset,&eset);
  
  int gfd =  MAX (gfdw,gfdc);
  
  if (! killed) 
    {
      // add listen()ing socket to set
      gfd=MAX(listener->getfd(),gfd);
      FD_SET(listener->getfd(),&rset);
    }
      
  int r = select (gfd+1,&rset,&wset,&eset,NULL);
  
  return r;
}

int HTTPInternalProxy::addworker()
{
  Worker * w=server->createworker();
  if(w)
    {
      workers.add(w);
      w->dec();
      return 0;
    }
    
  perror("Error creating worker");
  return -1;
}

int HTTPInternalProxy::sched()
{
  // old connections have higher priority than new connections
  // schedule 'em all!!

  // as the first thing we work with the old connections
  ObjectList::Item  * i=inputconns.head();
  int j;
  for (j=0; i; ++j,i=i->next())
    {
      SchedEndpoint * p= dynamic_cast<SchedEndpoint*>(i->value());
      InputConn* c = dynamic_cast<InputConn*> (p);
      MYASSERT(c!= NULL);

      // MYTRACE ("data ready from inputconn");

      int r=0;
      if(FD_ISSET(c->getfd(),&rset))
	r=c->handleread();

      if (r<0)
	{
	  destroyinputconn(c);
	  continue;
	}
      if(FD_ISSET(c->getfd(),&wset))
	r=c->handlewrite();

      if (r<0)
	{
	  destroyinputconn(c);
	  continue;
	}

      if(FD_ISSET(c->getfd(),&eset))
	r=c->handleerror();

      if (r<0)
	destroyinputconn(c);
    }
  
  i=workers.head();
  for (j=0; i;++j,i=i->next())
    {
      SchedEndpoint * p= dynamic_cast<SchedEndpoint*>(i->value());
      Worker* w = dynamic_cast<Worker*> (p);
      MYASSERT(w!=NULL);

      //      MYTRACE("data ready from worker");

      int r=0;
      if(FD_ISSET(w->getfd(),&rset))
	r=w->handleread();
      if (r<0)
	{
	  destroyinputconn(w->getconn()); // TODO : check this!
	  destroyworker(w);
	  continue; 
	}

      if(FD_ISSET(w->getfd(),&wset))
	r=w->handlewrite();
      if (r<0)
	{
	  destroyinputconn(w->getconn()); // TODO: check this!
	  destroyworker(w);
	  continue; 
	}

      if(FD_ISSET(w->getfd(),&eset))
	r=w->handleerror();
      if (r<0)
	{
	  destroyinputconn(w->getconn()); // TODO: check this!
	  destroyworker(w);
	}
    }

  // as the last we accept eventually new connections
  
  if (FD_ISSET(listener->getfd(), &rset) && ! killed)
    {
      Socket *s = listener->accept();
      if (!s)
	{
	  perror("accept()"); 
	  return -1;
	}
      createinputconn(s);  
    }   
  return 0;
}

int HTTPInternalProxy::createinputconn(Socket * s)
{
  SchedEndpoint * i = new InputConn(s->getfd(),this);
  i->setfdmask(SchedEndpoint::READ);
  inputconns.add(i);
  i->dec();
  return 0;
}

int HTTPInternalProxy::destroyinputconn(InputConn* ic)
{
  Worker * w = ic->getworker();
  if (w)
    {
      w->reset();
      //      if (w->reset()<0)
	{
	  workers.remove(w); // KILL PROCESS
	  addworker(); // CREATE NEW PROCESS. TODO: improve mechanism!
	}
    }
  inputconns.remove(ic);
  return 0;
}


// WARNING! be sure that worker is not associated with a connection!
// this will close the socket!

int HTTPInternalProxy::destroyworker(Worker* w)
{
  InputConn * c = w->getconn();
  if (c)
    {
      c->reset();
      //      if (c->reset()<0)
	{
	  // kill connection
	  inputconns.remove(c); // KILL CONNECTION
	}
    }
  workers.remove(w);
  return 0;
}


Worker* HTTPInternalProxy::getidle()
{

  ObjectList::Item *i = workers.head();
  int j;
  for (j=0; i;++j,i=i->next())
    {
      SchedEndpoint * p= dynamic_cast<SchedEndpoint*>(i->value());
      Worker* w = dynamic_cast<Worker*> (p);
      MYASSERT(w!=NULL);
      if (! w->getconn())
	{
	  return w;
	}
    }

  // no workers left!!
  // TODO Implement resizing policy, according to global load
  // by now we create a new worker.

  
  MYASSERT(addworker()>=0);
  return getidle();
}
