// -*- Mode: C++ -*-
// Copyright (C) 2005 Aldo Nicolas Bruno

/*
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include <sys/types.h>
#include <regex.h>

#include <xstring.h>

#include "httpserver.h"
#include "httpconnection.h"
#include "httpservertoken.h"
#include "httpheader.h"
#include "httprequestheader.h"
#include "httpgetparamlist.h"

#include "syntax.h"


HTTPGETParamList::HTTPGETParamList ()
{
 
}

int fromhex(char c)
{
  if (c>='a'&&c<='f') return 10+c-'a';
  if (c>='A'&&c<='F') return 10+c-'A';
  if (c>='0'&&c<='9') return c-'0';
  else return -1;
}

xstring HTTPGETParamList::unescape_request(const xstring& s)
{
  int i,j;
  long l=s.length();
  xstring r(l+1);  
  for(i=0,j=0; i<l;++i)
    {
      if(s[i]=='%')
	{
	  if(i+2<l)
	    {
	      int 
		a=fromhex(s[i+1]),
		b=fromhex(s[i+2]);
	      if (a<0||b<0) 
		{
		   r[j++]=s[i];	    
		   continue;
		}
	      r[j++]=a*16+b; 
	      i+=2;
	    }
	}
      else if (s[i]=='+')
	{
	  r[j++]=' ';
	}
      else
	r[j++]=s[i];
    }
  r[j]=0;
  return r;
}

int HTTPGETParamList::process (const xstring& params)
{
  clear();

  xstringvector x=params.splitc('&');
  
  long n=x.n();
  long i;

  for (i=0 ; i<n; ++i)
    {
      xstringvector z = x[i].splitc('=');    
      if (z.n()>0)
	{
	  setitem( unescape_request(z[0]),   // name
		   z.n()>1?unescape_request(z[1]):""); // value
	}
      else
	{ //FIXME!!
	  cout << "huston, we gotta problem!!! HTTPGETParamList::process: xstring::splitc returned NULL, we r running out of memory?!?!\n";
	 
	}
      // fprintf ( stdout, "Header: name: %s value: %s\n",wn[j].text(),wv[j].text());
    }
  
  return 0;
}
