// -*- Mode: C++ -*-
// Copyright (C) 2005 Aldo Nicolas Bruno

/*
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "common.h"
#include <xstring.h>
#include "socket.h"
#include "syntax.h"
#include "httpcresource.h"
#include "httpcresponse.h"
#include "httpclient.h"
#include "httpservertoken.h"
#include "httprequestheader.h"
#include "httpconnection.h"
#include "httptime.h"

HTTPCResponse::HTTPCResponse(HTTPConnection* conn, HTTPClient * cli)
{
  my_conn=conn;
  my_client=cli;
  my_header=0; //NULL
  my_data="";
}

HTTPCResponse::~HTTPCResponse()
{
  if(my_header) delete my_header;
}

HTTPCResource HTTPCResponse::receive()
{
  HTTPServerToken t(my_conn);
  
  xstringvector seps (4);

  seps.append(CRLF);
  seps.append(CR);
  seps.append(LF);
  
  xstring statusline;

  int r = t.gettoken (seps,statusline);
  
  xstringvector v = statusline.splitc(' ');
  /// TODO!! XXX 

  if(my_header) delete my_header;
  my_header=new HTTPRequestHeader (my_conn);
  
  my_header->readandprocessheader();
  
  xstring tcl = my_header->getitem("Content-Length");
  long cl=tcl.getlong();

  xstring data;

  if(cl>0)
    {
      data=my_conn->popn(cl);
    }
  HTTPTime taim (my_header->getitem("Date"));

  return HTTPCResource("",data,my_header->getitem("Content-Type"),taim.gettime(),my_conn->timeout()?-1:0);
}
