// -*- Mode: C++ -*-
// Copyright (C) 2005 Aldo Nicolas Bruno

/*
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef __HTTP_CRESOURCE_H__
#define __HTTP_CRESOURCE_H__

#include <sys/types.h>
// container for the response data;
class HTTPCResource
{
  xstring my_data;
  xstring my_mime;
  xstring my_url;
  time_t my_date;

  int my_status;
 public:
  HTTPCResource(const xstring& url, const xstring& data, const xstring& mime, time_t date, int status);
  
  xstring getdata() const;
  xstring getmime() const;
  xstring geturl () const;
  time_t getdate() const;
  int getstatus() const;
};

inline int HTTPCResource::getstatus() const
{
  return my_status;
}

inline xstring HTTPCResource::getdata() const
{
  return my_data;
}

inline xstring HTTPCResource::getmime() const
{
  return my_mime;
}

inline xstring HTTPCResource::geturl() const
{
  return my_url;
}

inline time_t HTTPCResource::getdate () const
{
  return my_date;
}

#endif
