// -*- Mode: C++ -*-
// Copyright (C) 2005 Aldo Nicolas Bruno

/*
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "common.h"
#include "syntax.h"
#include "httpcrequest.h"
#include "httpclient.h"


HTTPCRequest::HTTPCRequest(HTTPConnection *conn, HTTPClient *cli)
  :write(conn,NHBUFFERLEN)
{
  my_conn=conn;
  my_client=cli;
}

int HTTPCRequest::prepare(const xstring& method, const xstring& res, const xstringhash& headers, const xstring & data)
{
  my_method=method;
  my_headers=headers;
  my_data=data;
  my_res=res;
  return 0;
}

int HTTPCRequest::send()
{
  write << my_method << SP << my_res << SP << "HTTP/1.1" << CRLF;

  write << "Host: " << my_client->gethost() << CRLF;
  write << "User-Agent: " << "NHTTPC/0.8" << CRLF;
  
  if(my_data.length()>0 && (my_method == "POST" || my_method=="PUT") )
    {
      write << "Content-Length: " << xstring::fromlong(my_data.length()) << CRLF;
    }
  
  size_t n=my_headers.getsize() , i;
  for (i=0; i<n; ++i)
    {
      write << my_headers.getvalue(i) << CRLF;
    }
  write << CRLF;
  
  write << my_data;
  write.flush();
  return 0;
}
