// -*- Mode: C++ -*-
// Copyright (C) 2005 Aldo Nicolas Bruno

/*
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/


#include <xstring.h>
#include "httpcookie.h"

#include <xstring.h>

#include "httpserver.h"
#include "httpconnection.h"
#include "httpservertoken.h"
#include "httpheader.h"
#include "httprequestheader.h"
#include "httpgetparamlist.h"

#include "syntax.h"


HTTPCookie::HTTPCookie(const xstring& line)

{
  fromstring(line);
}

long HTTPCookie::fromstring(const xstring& line)
{
  clear();
  
  xstringvector x=line.splitc(';');
  // if(!x) return -1;
  long n=x.n();
  long i;
  for (i=0 ; i<n; ++i)
    {
      xstringvector z = x[i].splitc('=',1);    
      if (z.n()>0)
	{
	  // fprintf(stdout,"z0: %s\nz1: %s",z[0]->text(),z[1]->text());
	  xstring a,b;
	  a=HTTPGETParamList::unescape_request(z[0]);
	  a.trim(); // remove leading and trailing blank spaces
	  
	  b= (z.n()>1) ? HTTPGETParamList::unescape_request(z[1]) : "";
	  b.trim();

	  setitem( a,   // name
		   b); // value
	 	  
	}
      else
	{ // FIXME!!
	  cout << "HTTPCookie::process: xstring::splitc returned NULL, we r running out of memory?!?!\n";
	 
	}
      // fprintf ( stdout, "Header: name: %s value: %s\n",wn[j].text(),wv[j].text());
    }
  return 0;
}
