// -*- Mode: C++ -*-
// Copyright (C) 2005 Aldo Nicolas Bruno

/*
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/


#ifndef __NYCOLAS_HTTP_SERVER_CONNECTION_H__
#define __NYCOLAS_HTTP_SERVER_CONNECTION_H__

#include "object.h"
#include "socket.h"
#include "inetsocket.h"

class HTTPConnection: public virtual Object
{
  HTTPConnection(){};
  //HTTPServer *server;
  Socket *socket;
  
  long pos;
  unsigned long timeout_usecs;
  unsigned long retry_usecs;
  unsigned long timeoutct;
  xstring buff;
public:
  HTTPConnection(Socket *sokt);
  int handle ();
  int disconnect();
  // Socket* getsocket();
  // HTTPServer * getserver(){return server;}
  long send(const xstring& data);
  long read(int n = 32768);
  const xstring& buffer() const; 
  xstring buffernew() const;
  long length() const;
  long position() const;
  void position (long p);
  bool dataready() ;
  bool bufferready() const;
  long readblocking();
  long readblockingn(long n);
  xstring popn(long n);
  bool timeout();
  void clear();
};

#endif // __NYCOLAS_HTTP_SERVER_CONNECTION_H__
