// -*- Mode: C++ -*-
// Copyright (C) 2005 Aldo Nicolas Bruno

/*
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/


#include <xstring.h>
#include "socket.h"
#include "syntax.h"
#include "httpconnection.h"
//#include "connectionbuffer.h"

#include "httpcrequest.h"
#include "httpclient.h"


HTTPClient::HTTPClient(const xstring& host, int port)
{
  my_host=host;
  my_port=port?port:80;
}

int HTTPClient::connect()
{
  s.connect(my_host.text(),my_port);
  return 0;
}

HTTPCResource HTTPClient::request(const xstring & method, const xstring& res , const xstringhash& headers, const xstring & data)
{
  HTTPConnection c(&s);
  HTTPCRequest req(&c,this);
  req.prepare(method,res,headers,data);
  req.send();
  
  HTTPCResponse resp (&c,this);

  HTTPCResource r = resp.receive();

  return r;
}

xstring HTTPClient::gethost() const
{
  return my_host + ":" + xstring::fromint(my_port);
}

int HTTPClient::getstatus() const
{
  if (s.check()<0) return -1;

  return 0;
}
