// -*- Mode: C++ -*-
// Copyright (C) 2005 Aldo Nicolas Bruno

/*
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef __NYCOLAS_HASH_H__
#define __NYCOLAS_HASH_H__
#include "objectlist.h"

class hashitem : public virtual Object
{
public:
  hashitem(const xstring& name, const xstring& value)
    :Object("hashitem")
  {
    this->name=name;
    this->value=value;
  }
  xstring name,value;
};

enum 
  {
    HASH_MATCH_CASE=0,
    HASH_MATCH_NOCASE
  };


class Hash:public virtual Object
{
  ObjectList my_l;

 protected:

  int match;
  ObjectList::Item * finditem(const xstring& name) const;
  ObjectList::Item * getfirst();
  ObjectList::Item * getlast();
  
 public: 
  Hash();
  virtual ~Hash();

  void setitem(const xstring& name, const xstring& value);
  void delitem(const xstring& name);
  xstring getitem(const xstring& name) const;
  bool hasitem(const xstring& name) const;
  long getsize() const;

  int getitem(long pos,xstring& name, xstring& value) const; 

  virtual void clear();
  
  void setmatch(int x); 
};

#endif // __NYCOLAS_HASH_H__
