
// -*- Mode: C++ -*-
// Copyright (C) 2005 Aldo Nicolas Bruno

/*
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include <xstring.h>
#include "hash.h"

Hash::Hash()
{
  match=HASH_MATCH_CASE;
}

Hash::~Hash()
{
  clear();
}

void Hash::clear()
{
  my_l.clear();
}

void Hash::setitem(const xstring& name, const xstring& value)
{
  ObjectList::Item* r=finditem(name);
  if(!r) // if it does not exist, insert it
    {
      hashitem *r=new hashitem(name,value);
      my_l.additem(r);
      r->dec();
    }
  else
    {
      hashitem * v=dynamic_cast<hashitem*>(r->value());
      v->name=name; // if case insensitive this will do the right thing..
      v->value=value;
    }
}

ObjectList::Item* Hash::finditem(const xstring& name) const
{
  const ObjectList::Item* p=my_l.head();

  for (;p;p=p->next())
    {
      hashitem * v= dynamic_cast<hashitem*>(p->value());
      if (match==HASH_MATCH_NOCASE)
	{
	  if(name.comparenocase(v->name)==0) 
	    return (ObjectList::Item*)p;
	}
      else
	{
	  if(name==v->name) 
	    return (ObjectList::Item*)p;
	}
    }
  return 0; // (NULL)
}

ObjectList::Item* Hash::getfirst()
{
  return my_l.head();
}

ObjectList::Item* Hash::getlast()
{
  return my_l.tail();
}

xstring Hash::getitem(const xstring& name) const
{
  ObjectList::Item * i = finditem(name);
  if(i) 
    {
      hashitem *v = dynamic_cast<hashitem*>(i->value());
      return v->value;
    }
  return "";
}

bool Hash::hasitem(const xstring& name) const
{
  return finditem(name)!=0;
}

long Hash::getsize() const
{
  return my_l.getsize();
}

void Hash::setmatch(int x)
{
  match=x;
}

int Hash::getitem(long pos,xstring& name, xstring& value) const
{
  long i;
  const ObjectList::Item *p=my_l.head();
  if (pos<0) return 0;

  for(i=0; p; ++i,p=p->next())
    {
      if (i==pos) 
	{
	  hashitem *v =dynamic_cast<hashitem*>(p->value());
	  name=v->name;
	  value=v->value;
	  return 1; // ok
	}
    }
  return 0; // not found
}
