// -*- Mode: C++ -*-
//
//    FD - File Descriptor
//
//    Copyright (C) 2005 Aldo Nicolas Bruno
//
//    Linux Users Group San Fidenzio
//

/*
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/ 

#ifndef __FD_H__
#define __FD_H__
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>


#include "object.h"


class FD : public virtual Object
{
 
 protected:
  int fd; 
  int checkval;
 public:
  FD();
  FD(int fd);
  int close();

  char *read(int &n);
  int write(const char*s,int n=-1);

  int check() const;
  
  virtual ~FD();

  void setfd(int fd);
  int getfd() const;
}; 

#endif // __FD_H__
