// -*- Mode: C++ -*-
//
//    FD - File Descriptor
//
//    Copyright (C) 2005 Aldo Nicolas Bruno
//
//    Linux Users Group San Fidenzio
//

/*
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/ 
#include "fd.h"

FD::FD()
  :Object("FD")
{
  fd=-1;
}

FD::FD(int fd)
  :  Object ("FD")
{
  this->fd=fd;
  checkval=0;
}

FD::~FD()
{
  close();
}
  

int FD::close()
{
  if (fd<0) return -1;
#ifdef DEBUG
  std::cout << "Closing fd... ";
#endif
  if(::close (fd) == -1)
    {
      perror("close");
      return checkval=-1;
    }
#ifdef DEBUG
  std::cout <<  " ok\n";
#endif
  fd=-1;
  return checkval=0;
}

char* FD::read(int & n)
{
  if (fd<0) return NULL;
  char * b=new char[n+5];
  n=::read(fd,b,n);
  if (n>=0) b[n]=0;
  checkval=n<0?n:0;
  return b;

  /*
  if (fd<0) return NULL;
  char * b=new char[n+5];
  n=::read(fd,b,n);
  checkval=n<0?n:0;
  return b;
  */
}

int FD::write(const char*s,int n)
{
  if (fd<0) return -1;
  int i;
  if(n<0) n=strlen(s);
  i=::write(fd,s,n);
  checkval=i<0?i:0;
  return i;
}

int FD::getfd() const
{
  return fd;
}

void FD::setfd(int fdd)
{
  checkval=0;
  fd=fdd;
}


int FD::check() const
{
  return checkval;
}
