// -*- Mode: C++ -*-
// Copyright (C) 2005 Aldo Nicolas Bruno

/*
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef COnnectionBUFFER_H__
#define COnnectionBUFFER_H__

#include <xstring.h>

#include "httpserver.h"
#include "httpconnection.h"

class ConnectionBuffer
{
  xstring my_buffer;
  size_t my_length;
  HTTPConnection* my_conn;
  int _status;
public:
  ConnectionBuffer(HTTPConnection* c, size_t length=0);
  ~ConnectionBuffer(); 
  ConnectionBuffer(); 
  
  int  status() const;

  void length (size_t len);
  size_t length() const;

  void flush();

  int append(const xstring & s);
  
  ConnectionBuffer& operator << (const xstring & s);
  ConnectionBuffer& operator << (long l);
  ConnectionBuffer& operator << (double d);
  ConnectionBuffer& operator << (char c);
  ConnectionBuffer& operator << (const char* s);
};

#endif

