// -*- Mode: C++ -*-
// Copyright (C) 2005 Aldo Nicolas Bruno

/*
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include <connectionbuffer.h>

ConnectionBuffer::ConnectionBuffer(HTTPConnection* c, size_t length)
{
  my_conn=c;
  my_length=length;
  _status=0;
}

ConnectionBuffer::~ConnectionBuffer()
{
  flush();
}

int ConnectionBuffer::status()const
{
  return _status;
}

ConnectionBuffer::ConnectionBuffer()
{
  my_conn=0;
  my_length=0;
}

void ConnectionBuffer::length(size_t len)
{
  my_length=len;
}

size_t ConnectionBuffer::length() const
{
  return my_length;
}

int ConnectionBuffer::append(const xstring & s)
{
  if(s.length() <= 0 ) return 0;
  my_buffer += s;
  if ( my_buffer.length() >= my_length )
    {
      int i=my_conn->send ( my_buffer );
      if (i<0) return _status=i;
      my_buffer.clear();
    }
  return 0;
}

void ConnectionBuffer::flush()
{
  if ( my_buffer.length() > 0  )
    {
      int i=my_conn->send ( my_buffer );
      if (i<0)
	_status=i;
      else
	my_buffer.clear();
    } 
  //return 0;
}

ConnectionBuffer& ConnectionBuffer::operator << (const xstring & s)
{
  append(s);
  return *this;
}

ConnectionBuffer& ConnectionBuffer::operator << (long l)
{
  append(xstring::fromlong(l));
  return *this;
}


ConnectionBuffer& ConnectionBuffer::operator << (double d)
{
  append(xstring::fromdouble(d));
  return *this;
}

ConnectionBuffer& ConnectionBuffer::operator << (char c)
{
  append(xstring::fromxchr(c));
  return *this;
}

ConnectionBuffer& ConnectionBuffer::operator << (const char* s)
{
  append( xstring (s,false) );
  return *this;
}
