// -*- Mode: C++ -*-
// Copyright (C) 2005 Aldo Nicolas Bruno

/*
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/


#ifndef __common_H__
#define __common_H__

#include <cstdlib>
#include <cstdio>
#include <iostream>
using namespace std;

#include "config.h"

#include <xstring.h>

#ifdef DEBUG
#define MYASSERT(expr)((expr)? (void*)(0) : std::cerr << "ASSERTION FAILED!!: " << #expr << " file:" << __FILE__ << " line " << __LINE__ << endl)

#define MYTRACE(expr)(std::cerr << "Trace: " << __FILE__ << ":" << __LINE__ << ": " << expr << endl)

#else
#define MYASSERT(expr)(void*)(0)
#define MYTRACE(expr)(void*)(0)
#endif


// definizioni banali
#ifndef MIN
# define MIN(a,b)((a)>(b)?(b):(a))
#endif


#ifndef MAX
# define MAX(a,b) ((a)>(b)?(a):(b))
#endif

#define NHBUFFERLEN 32768

#endif // __common_H__
