#! /usr/bin/python

# Copyright (C) 2006 Aldo Nicolas Bruno

#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.

#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.

#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA



from generic import *

class txtitem(item):
    def __init__(self,doc):
        item.__init__(self,doc)

    def _render(self):
        pass

        #print "txtitem._render"
class txtvflow(txtitem,container):
    def __init__(self,doc):
        txtitem.__init__(self,doc)
        container.__init__(self,doc)
        
    def _render(self):
        ctx=self.doc.getcontext()
        for i in self.items:
            i._render()
            ctx.append("\n")

class txttext(txtitem,text):
    def __init__(self,doc,string):
        txtitem.__init__(self,doc)
        text.__init__(self,doc,string)
    
    def _render(self):
        #print "txttext._render"
        ctx=self.doc.getcontext()
        
        ctx.append(self.string.replace("\n",""))

class txtparagraph(txtitem,paragraph):
    def __init__(self,doc,string):
        txtitem.__init__(self,doc)
        paragraph.__init__(self,doc,string)
        
    def _render(self):
        ctx=self.doc.getcontext()

        ctx.append(self.string.replace("\n\n","<br>").replace("\n"," ").replace("<br>","\n").replace(" "," ").replace("\t",""))
        
class txtpagebreak(txtitem):
    def __init__(self,doc):
        txtitem.__init__(self,doc)

    def _render(self):
        self.doc.newpage()

        
class txtimage(txtitem):
    def __init__(self,doc,file):
        txtitem.__init__(self,doc)
        self.file=file
        
    def _render(self):
        ctx=self.doc.getcontext()
        ctx.append("#IMG: %s #" % self.file)

class txttable(table,txtitem):
    def __init__(self,doc):
        txtitem.__init__(self,doc)
        table.__init__(self,doc)

    def _render(self):
        ctx=self.doc.getcontext()

        for i in self.items:       
            for j in i:
                j._render()
                ctx.append("\t")
                
            ctx.append("\n")

class txtdocument(txtvflow,document):
    def __init__(self,txtcontext):
        txtvflow.__init__(self,self)
        document.__init__(self)#,txthash)
        self.ctx=txtcontext
        self.x=self.y=0
        self.n=0

    def newpage(self):
        #print "txtdocument.newpage"
        self.ctx.append("\f")        
        self.n+=1
            
    def getcontext(self):
        return self.ctx
            
    def generate(self):
        self.n=0
        self._render()

class TXTContext:
    def __init__(self,filename,columns=80):
        self.file=file(filename,"w")
        self.columns=columns
        
    def append(self,text):
        if len(text)==0:
            return

        text=text.replace("\t","    ")

        txt=text_fill(text,self.columns)
        
#        print "<", txt, ">\n"

        self.file.write(txt)
        self.file.flush()
        
txthash= {
    'image':   txtimage,
    'text':    txttext,
    'document':txtdocument,
    'vflow':   txtvflow,
    'table':   txttable,
    'paragraph': txtparagraph
    }


def freereport_txt(size,filename):
    ctx=TXTContext(filename,size[0]/8)
    return txtdocument(ctx)

