#! /usr/bin/python

# Copyright (C) 2006 Aldo Nicolas Bruno

#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.

#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.

#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA


## free report. A free report library with a flexible layout engine.
## We will possibly rewrite this in C or C++

import jaxml

from generic import *

        #print "htmlitem._render"
class htmlvflow(container):
    def __init__(self,doc):
        container.__init__(self,doc)
        
    def _render(self):
        ctx=self.doc.getcontext()
        for i in self.items:
            i._render()

class htmltext(text):
    def __init__(self,doc,string):
        text.__init__(self,doc,string)

    def _render(self):
        #print "htmltext._render"
        ctx=self.doc.getcontext()
#        ctx._push()
        ctx._text(self.string)#self.string.replace("\n\n","<br />")) # .replace ("\n","<br/>")))
#        ctx._pop()

class htmlparagraph(paragraph):
    def __init__(self,doc,string):
        paragraph.__init__(self,doc,string)
        
    def _render(self):
        ctx=self.doc.getcontext()

        ctx.p(self.string.replace("\n\n","<br/>"))

class htmlpagebreak(item):
    def __init__(self,doc):
        item.__init__(self,doc)

    def _render(self):
        #print "htmlpagebreak._render"
        self.doc.newpage()
        
class htmlimage(image):
    def __init__(self,doc,file,w=0,h=0):
        image.__init__(self,doc,file,w,h)
        
    def _render(self):
        #print "pngimage._render"
        
        attrib={}
        w,h=0,0
        if self.style.has_key("width"):
            w=self.getattrib("width")

        if self.style.has_key("height"):
            h=self.getattrib("height")
            
        if self.w >0:
            attrib['width']=self.w
        elif w>0:
            attrib['width']=w
        
        if self.h >0:
            attrib['height']=self.w
        elif h>0:
            attrib['height']=w
        
        ctx=self.doc.getcontext()
        ctx._push()
        ctx.img(src=self.file,**attrib)
        ctx._pop()

class htmltable(table):
    def __init__(self,doc):
        table.__init__(self,doc)

    def _render(self):
        ctx=self.doc.getcontext()
        
        ctx._push()
        border='border: solid; border-width:%spx;'%self.getattrib('border')
        ctx.table(border=0,width="100%")
        ctx._push()
        for i in self.items:
            ctx._push()
            ctx.tr()
            ctx._push()
            for j in i:
                ctx._push()

                if j.hasattrib('colspan'):
                    ctx.td(colspan=j.getattrib('colspan'),style=border)
                else:
                    ctx.td(style=border)
                ctx._push()
                j._render()
                ctx._pop()
                ctx._pop()
            ctx._pop()
            ctx._pop()

        ctx._pop()
        ctx._pop()
    

class htmldocument(document):
    def __init__(self,jaxmlctx):
        document.__init__(self)
        
        self.ctx=jaxmlctx
        self.x=self.y=0
        self.n=0

    def newpage(self):
        #print "htmldocument.newpage"
        self.ctx._push()
        self.ctx.hr(width="1")
        self.ctx._pop()
        
        self.n+=1
            
    def getcontext(self):
        return self.ctx
            
    def generate(self):
        self.n=0
        
        self.ctx.html().body().table(
            width="100%"
            ).tr().td()
  
        for x in self.items:
            self.ctx._push()
            x._render()
            self.ctx._pop()

        x=file(self.ctx.filename,"w")
        x.write(str(self.ctx))
        x.close()

    def vflow(self,*v,**kv):
        return htmlvflow(self,*v,**kv)

    def text(self,*v,**kv):
        return htmltext(self,*v,**kv)

    def paragraph(self,*v,**kv):
        return htmlparagraph(self,*v,**kv)

    def drawing(self,*v,**kv):
        return htmldrawing(self,*v,**kv)

    def pagebreak(self,*v,**kv):
        return htmlpagebreak(self,*v,**kv)
    
    def table(self,*v,**kv):
        return htmltable(self,*v,**kv)

    def image (self,*v,**kv):
        return htmlimage(self,*v,**kv)    


def freereport_html(size,filename):
    ctx=jaxml.HTML_document()
    ctx.filename=filename
    return htmldocument(ctx)

