#! /usr/bin/python

# Copyright (C) 2006 Aldo Nicolas Bruno

#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.

#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.

#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

class item(object):
    """BASE CLASS FOR ALL ELEMENTS"""

    def __init__(self,doc):
        self.doc=doc
        self.style={'expand':True}     
        
    def setattrib(self,name,value):
        self.style[name]=value

    def hasattrib(self,name):
        return self.style.has_key(name)
    
    def getattrib(self,name):
        """ get style attribute """
        #        if self.style.has_key(name):
        return self.style[name]

    def setupsize(self,maxwidth,maxheight):
        print str(self),self.getsize()[0],self.getsize()[1]
        return self.getsize()

    def getsize(self):
        return self.w,self.h
    
    def maxwidth(self):        
        return self.getsize()[0]
    
    def maxheight(self):
        return self.getsize()[1]

    def setsize(self,w,h):
        self.w,self.h=w,h

    def _render(self):
        pass
    
## default container.
        
class container(item):
    """ Abstract Container """
    def __init__(self,doc):
        item.__init__(self,doc)
        self.setattrib('left-margin',0)
        self.setattrib('right-margin',0)
        self.setattrib('top-margin',0)
        self.setattrib('bottom-margin',0)

        self.items=[]
        
    def additem(self,a):
        self.items.append(a)

class vflow(container):
    """ Vertical Flow Container"""
    def __init__(self,doc):
        container.__init__(self,doc)
        pass
    
    def getsize(self):
        w=0
        h=0
        for i in self.items:
            iw,ih=i.getsize()
            w=max(w,iw)
            h+=ih
        return w,h

class text(item):
    """ text """
    def __init__(self,doc,string):
        item.__init__(self,doc)
        self.string=string

class paragraph(item):
    """ text paragraph """
    def __init__(self,doc,string):
        item.__init__(self,doc)
        self.string=string

class image(item):
    def __init__(self,doc,file,w=0,h=0):
        item.__init__(self,doc)
        self.file=file
        self.w,self.h=w,h

class drawing(item):
    """ drawing canvas """
    def __init__(self,doc,callback):
        item.__init__(self,doc)
        self.callback=callback

    def _render(self):
        self.callback(self.doc)

class pagebreak(item):
    """ page break """
    def __init__(self,doc):
        item.__init__(self,doc)

class table(container):
    """ table container """
    def __init__(self,doc):
        container.__init__(self,doc)
        self.setattrib("border",1)
        self.setattrib("background",(255,255,255))
        self.setattrib("width",-1)

    """ add row from item list """
    def addrow(self,columns,style={}):
        for a in columns:
            for k,v in style.iteritems():
                a.setattrib(k,v)
        
        self.items.append(columns)

    """ add row from text list """
    def addrow_txt(self,columns,style={}):
        w=[]
        for x in columns:
            a=self.doc.text(str(x))
            for k,v in style.iteritems():
                a.setattrib(k,v)
            w.append(a)

        self.items.append(w)

    def add_from_sql(self,dbapicursor,query):
        dbapicursor.execute(query)
        data=dbapicursor.fetchall()
        for t in data:
            self.addrow_txt(t)
#from exception import exception

class document(container):
    """main document container """
    def __init__(self):
        container.__init__(self,self)
        self.header=self.footer=None
#        self.hash=
        self.setattrib('left-margin',20)
        self.setattrib('top-margin',10)
        self.setattrib('right-margin',10)
        self.setattrib('bottom-margin',10)

    def _render(self):
        #   raise exception("document must use generate()")
        pass
    #def _render(self):
    #    vflow._render(self)

    def getcontext(self):
        return None
    
    def generate(self):
        self._render(self)
        
    def setheader(self,item):
        self.header=item

    def setfooter(self,item):
        self.footer=item

###
    def item(self,*v,**kv):
        return item(self,*v,**kv)

    def container(self,*v,**kv):
        return container(self,*v,**kv)
    
    def vflow(self,*v,**kv):
        return vflow(self,*v,**kv)

    def text(self,*v,**kv):
        return text(self,*v,**kv)

    def paragraph(self,*v,**kv):
        return paragraph(self,*v,**kv)

    def drawing(self,*v,**kv):
        return drawing(self,*v,**kv)

    def pagebreak(self,*v,**kv):
        return pagebreak(self,*v,**kv)
    
    def table(self,*v,**kv):
        return table(self,*v,**kv)

    def image(self,*v,**kv):
        return image(self,*v,**kv)

        
def text_fill(text,width):
    """ text fill function
    It limits to width the columns of text, breaking them with \\n
    """
    width=int(width)
    v=text.split('\n')

    txt=""
    for line in v:
        l=len(line)

        t=l/width
        r=l%width
        p=0

        for j in range(1,t+1):
            txt+=line[p:j*width]
            p=j
        
        if r>0:
            if t>0:
                txt+="\n"
            txt+=line[-r:]

        txt+="\n"

    if text[-1]!='\n':
        txt=txt[:-1]

    return txt
