#! /usr/bin/env python

# Copyright (C) 2006 Aldo Nicolas Bruno

#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.

#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.

#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA


## free report. A free report library with a flexible layout engine.
## We will possibly rewrite this in C or C++

import cairo
try:
    import cairo.svg
except:
    print "Warning: cairo.svg not found"
    
from generic import *
    

class cairovflow(container):    
    def __init__(self,doc):
        container.__init__(self,doc)
        
    def setupsize(self,maxwidth,maxheight):
        mw=self.maxwidth()
        #mh=self.maxheight()
        
        szw=0
        szh=0
        for i in self.items:
            szw=min(maxwidth,i.maxwidth())

        if self.getattrib('expand'):
            szw=maxwidth
            
        for i in self.items:
            szh+=i.setupsize(szw,maxheight-szh)[1]
            
        self.setsize(szw,szh)
        print str(self),szw,szh
        return szw,szh

    def maxwidth(self):
        m=0
        for i in self.items:
            m= max(i.maxwidth(),m)
        
        return m

    def maxheight(self):
        """return the sum of all children"""
        m=0
        for i in self.items:
            m+=i.maxheight()
        return m

    def _render(self):

        ctx=self.doc.getcontext()
        for i in self.items:
            w,h=i.getsize()
            if not isinstance (i,container):
                b=self.doc.needspace(w,h)
            m=ctx.get_matrix()
            x,y=self.doc.getposition()

            ctx.save()
            ctx.identity_matrix()
            ctx.translate(x,y)
            i._render()
            ctx.restore()
            
            if not isinstance (i,container):
                self.doc.setposition(x,y+h)

class cairotext(text):
    """ display a line of text """
    
    def __init__(self,doc,string):
        text.__init__(self,doc,string.replace("\n"," "))
        
        sr=doc.getcontext().text_extents(self.string)

        self.sz={}
        self.sz['x_bearing']=sr[0]
        self.sz['y_bearing']=sr[1]
        self.sz['width']=sr[2]
        self.sz['height']=sr[3]
        self.sz['x_advance']=sr[4]
        self.sz['y_advance']=sr[5]

        self.setsize(*self._getsize())
        
    def getsize(self):
        if self.getattrib('expand'):
            return item.getsize(self)
        return _getsize()

    def _getsize(self):
        sr=self.doc.getcontext().text_extents(self.string)
        return sr[2],sr[3]*1.25
        
    def setupsize(self,maxwidth,maxheight):
        ## FIXME ??
        if self.getattrib('expand'):
            self.setsize(maxwidth,
                         max(maxheight,self._getsize()[1])
                         )
        return self.getsize()

#    def maxwidth(self):
#        return self.getsize()[0]
    
#    def maxheight(self):
#        return self.getsize()[1]
        
    def _render(self):
        #print "cairotext._render"
        ctx=self.doc.getcontext()
        ctx.move_to(self.sz['x_bearing'],-self.sz['y_bearing'])
        ctx.show_text(self.string)

    def getextents(self):
        return self.sz

class cairoparagraph(cairovflow):
    def __init__(self,doc,string):
        cairovflow.__init__(self,doc)

        ctx=doc.getcontext()
        sz=ctx.text_extents("O")
        self.string=string
        #FIXME: what's the maximum size??
        self.string=text_fill(self.string,doc.w/sz[2])
#        print sz
        v=self.string.split('<br>')
#        w,h=0,0
        for i in v:
            txt=cairotext(doc,i)
            self.additem(txt)
#            h+=txt.getextents()['height']+txt.getextents()['y_advance']
#            w=max(w,txt.getextents()['x_advance'])
            
#        self.setsize(w,h)

class cairopagebreak(pagebreak):
    def __init__(self,doc):
        pagebreak.__init__(self,doc)

    def _render(self):
        #print "cairopagebreak._render"
        self.doc.newpage()

class svgimage(image):
    def __init__(self,doc,file,w=0,h=0):
        image.__init__(self,doc,file,w,h)
        self.svg = cairo.svg.Context()
        self.svg.parse (file)
        
    def getsize(self):
        w,h=self.svg.get_size()

        if self.style.has_key("width"):
            w=self.getattrib("width")

        if self.style.has_key("height"):
            h=self.getattrib("height")
            
        if self.w >0:
            w=self.w        
        if self.h >0:
            h=self.w
        
        return w,h
                
    def _render(self):
        #print "svgimage._render"
        ctx=self.getcontext()
        ctx.save()
        w,h=self.getsize()
        i,j=self.svg.get_size()

        ctx.scale(float(w)/i,float(h)/j)
        
        self.svg.render(ctx)
        ctx.restore()
        #ctx.move_to(0,self.h)
        
class pngimage(image):
    def __init__(self,doc,file,w=0,h=0):
        image.__init__(self,doc,file,w,h)
        self.png=cairo.ImageSurface.create_from_png(file)
        
    def getsize(self):
        w,h=self.png.get_width(),self.png.get_height()

        if self.style.has_key("width"):
            w=self.getattrib("width")

        if self.style.has_key("height"):
            h=self.getattrib("height")
            
        if self.w >0:
            w=self.w        
        if self.h >0:
            h=self.w
        
        return w,h

    def _render(self):
        #print "pngimage._render"
        ctx=self.doc.getcontext()
        ctx.save()
        #        ctx.translate(0,self.getsize()[1])
        w,h=self.getsize()
        i,j=self.png.get_width(),self.png.get_height()

        ctx.scale(float(w)/i,float(h)/j)
        
        ctx.set_source_surface(self.png)

        ctx.paint()
        ctx.restore()

#Mhuehehehe
# We simulate a class constructor
# We wrap between svgimage and pngimage
# in base of the filename extension

def cairoimage(doc,file):
    v=file.split('.')
    if len(v) <2:
        raise Exception("Nome file non valido")
    ext=v[-1].lower()

    if ext == 'svg':
        return svgimage(doc,file)
    elif ext == 'png':
        return pngimage(doc,file)
    
    raise Exception ("File non supportato: " + file)

class cairotable(table):    
    def __init__(self,doc):
        table.__init__(self,doc)
        self.xpad=5
        self.ypad=5
        
    def setupsize(self,maxwidth,maxheight):
        mw=self.maxwidth()
        #mh=self.maxheight()
        print "mw",mw
        szw=0
        szh=0
        iw=0
        
        for i in self.items: #rows
            w=0
            for j in i:      #columns
                w+=j.maxwidth()+self.xpad*2
            iw=max(w,iw)

        if self.getattrib('expand'):
            szw=maxwidth
        else:
            szw=iw
        
        ## legge proporzionale ;)
        r=float(maxwidth)/iw
        print "erre",r

        w,h=0,0
        
        for i in self.items:
            for j in i:
                sz=j.setupsize(j.maxwidth()*r,maxheight-szh)
                print "sz",sz
                h+=sz[1]+self.ypad*2
                w+=sz[0]+self.xpad*2
        
        self.setsize(w,h)
        print str(self),w,h
        return w,h

    ## FIXME
    def maxwidth(self):
        m=0
        for i in self.items:
            u=0
            for j in i:
                u+= j.maxwidth()+self.xpad*2
            m=max(u,m)
        
        return m

    def maxheight(self):
        m=0
        for i in self.items:
            u=0
            for j in i:
                u=max(u,j.maxheight()+self.ypad*2)
            m+=u
        return m

    def _render(self):
        ctx=self.doc.getcontext()
        
        border=self.getattrib('border')

        c={}
        for i in self.items:          #rows
            for k,j in enumerate(i):     #columns
                
                t=0
                if j.hasattrib('colspan'):
                    t=j.getattrib('colspan')
                    if t>1:
                        continue
                
                w=j.getsize()[0]
                if c.has_key(k):
                    c[k]=max(w+self.xpad*2,c[k])
                else:
                    c[k]=w+self.xpad*2

        #rescan
        for i in self.items:
            for k,j in enumerate(i):
                t=0
                if j.hasattrib('colspan'):
                    t=j.getattrib('colspan')
                    if t>1:
                        w=j.getsize()[0]+self.xpad*2
                        x=0
                        for m in range(0,t):
                            x+=c[k+m]+self.xpad*2
                        for m in range(0,t):
                            c[k+m]=max(c[k+m],c[k+m]*w/x)
        
        
        border=self.getattrib('border')

        for i in self.items:
            w,h=i[0].getsize()#FIXME
            if not isinstance (i,container):
                b=self.doc.needspace(w,h)
            m=ctx.get_matrix()
            x,y=self.doc.getposition()
            
            ctx.save()
            ctx.identity_matrix()
            ctx.translate(x,y)
            xp=x
            for k,j in enumerate(i):
                j._render()
                t=c[k]
                if j.hasattrib('colspan'):
                    for m in range(1,j.getattrib('colspan')):
                        t+=c[k+m]+self.xpad*2

                cellborder=0
                if j.hasattrib('border'):
                    cellborder=j.getattrib('border')
                
                if cellborder>0:
                    ctx.set_line_width(cellborder)
                    ctx.rectangle(-self.xpad,-self.ypad,
                                  t+self.xpad*2,h+self.ypad*2)
                    ctx.stroke()
                    
                ctx.translate(t+2*self.xpad,0)
                xp+= t+2*self.xpad
                self.doc.setposition(xp,y)

            ctx.restore()
            if not isinstance (i,container):
                self.doc.setposition(x,y+h+self.ypad*2)

##         border=0
##         if j.hasattrib('border'):
##             border=j.getattrib('border')
            
##         if border>0:
##             ctx.set_line_width(border)        
##             ctx.rectangle(-self.xpad,-self.ypad,
##                           self.w+self.xpad,self.h+self.ypad)
##             ctx.stroke()


#    def getsize(self):
#        w=50*len(self.items)
#        h=0
#        
#        for i in self.items:
#            h+=i[0].getsize()[1]

#        return w,h

class cairodocument(document):
    def __init__(self,cairoctx,s):
        document.__init__(self)

        self.ctx=cairoctx
        self.x,self.y=self.getattrib("left-margin"),self.getattrib("top-margin")
        self.n=0
        self.surface=s
        
    def newpage(self):
        #print "cairodocument.newpage"
        self.x=self.getattrib("left-margin")
        self.y=self.getattrib("top-margin")
        
        self.ctx.show_page() ## render page
        self.ctx.identity_matrix() ## reset transformations
        self.n+=1
        
    def needspace(self,w,h):
        print "needspace: ",w,h,
        delta=self.h-(self.y+h)
        print delta
        if delta<0:
            if delta<-self.h:
                #print "Impossible!!! The element is bigger than the page!"
                return -1
            self.newpage()
            return 2 # created new page
        return 1 # the contents fit!
        
    def setposition(self,x,y):
        self.x,self.y=x,y

    def getposition(self):
        return self.x,self.y
    
    def getcontext(self):
        return self.ctx
    
    def getsize(self):
        return self.w,self.h
            
    def generate(self):

        f=cairovflow(self)
        f.items=self.items
        
        f.setupsize(self.w,100000000)        

        self.n=0
        f._render()
        
        self.ctx.show_page()
        self.surface.flush()
        self.surface.finish()
    
    def vflow(self,*v,**kv):
        return cairovflow(self,*v,**kv)

    def text(self,*v,**kv):
        return cairotext(self,*v,**kv)

    def paragraph(self,*v,**kv):
        return cairoparagraph(self,*v,**kv)

    def drawing(self,*v,**kv):
        return cairodrawing(self,*v,**kv)

    def pagebreak(self,*v,**kv):
        return cairopagebreak(self,*v,**kv)
    
    def table(self,*v,**kv):
        return cairotable(self,*v,**kv)

    def image (self,*v,**kv):
        return cairoimage(self,*v,**kv)
    
    
def freereport_pdf(size,filename):
    s=cairo.PDFSurface(filename,*size)
    ctx=cairo.Context(s)
    doc=cairodocument(ctx,s)
    sz=size
    doc.setsize(*size)
    return doc

def freereport_ps(size,filename):
    s=cairo.PSSurface(filename,*size)
    ctx=cairo.Context(s)

    return cairodocument(ctx,s)

## FIXME: does this work correctly????
def freereport_png(size,filename):
    s=cairo.ImageSurface(filename,*size)
    ctx=cairo.Context(s)

    return cairodocument(ctx,s)
