CREATE TABLE persone (
	codice varchar(15) NOT NULL,
	nome varchar(100),
	indirizzo varchar(50),
	citta varchar(100),
	cap integer,
	nazione varchar(2),
	pi varchar(25),
	tipo_pagamento varchar(60),
	dilazione integer,
	banca varchar(60),
	cc varchar(50),
	iban varchar(60),
	contatto varchar(30),
	telefono varchar(30),
	fax varchar(30),
	email varchar(50),
	web varchar(50),
	"f" boolean,
	"c" boolean,
	note text,
	CONSTRAINT pk_persone PRIMARY KEY (codice));
CREATE TABLE codici_gifi (
	codice_gifi varchar(15) NOT NULL,
	descrizione_gifi varchar(150)
);
CREATE TABLE articoli_um (
	codice varchar(4) NOT NULL,
	descrizione varchar(50),
	testo_um text,
	CONSTRAINT pk_articoli_um PRIMARY KEY (codice));
CREATE TABLE articoli_tipi (
	codice varchar(10) NOT NULL,
	descrizione varchar(100),
	conto_cont_acq text,
	conto_cont_ven text,
	CONSTRAINT pk_articoli_tipi PRIMARY KEY (codice));
CREATE TABLE articoli (
	codice varchar(15) NOT NULL,
	descrizione varchar(50),
	um varchar(4),
	tipo varchar(10),
	prezzo_std numeric(13, 3),
	cod_fornitore varchar(15),
	punto_riordino numeric(12, 2),
	picche boolean,
	testo text,
	conto_contabile text,
	CONSTRAINT pk_articoli PRIMARY KEY (codice));
ALTER TABLE articoli ADD CONSTRAINT "$1" FOREIGN KEY (um) REFERENCES articoli_um(codice);
ALTER TABLE articoli ADD CONSTRAINT "$2" FOREIGN KEY (tipo) REFERENCES articoli_tipi(codice);
CREATE SEQUENCE _n_f_seq;
CREATE TABLE ddt_fornitore (
	n_f integer NOT NULL DEFAULT nextval('_n_f_seq'),
	fornitore varchar(15),
	data_f text,
	note_f text,
	numero_ddt_for text,
	confermata boolean DEFAULT false,
	CONSTRAINT pk_ddt_fornitore PRIMARY KEY (n_f));
CREATE SEQUENCE _id_fase_odp_seq;
CREATE TABLE fase_odp (
	id_fase_odp integer NOT NULL DEFAULT nextval('_id_fase_odp_seq'),
	data_inizio date,
	data_fine date,
	n_odp text,
	descr_fase_odp text,
	note_fase_odp text,
	bloccato boolean,
	CONSTRAINT pk_fase_odp PRIMARY KEY (id_fase_odp));
CREATE TABLE codici_iva (
	codice_iva varchar(5) NOT NULL,
	descrizione varchar(100),
	conto_iva_d varchar(50),
	conto_iva_c varchar(50),
	aliquota integer,
	CONSTRAINT pk_codici_iva PRIMARY KEY (codice_iva));
CREATE SEQUENCE _id_oda_seq;
CREATE TABLE oda (
	id_oda integer NOT NULL DEFAULT nextval('_id_oda_seq'),
	data_oda date,
	codice_forn_oda varchar(15),
	note_oda text,
	CONSTRAINT pk_oda PRIMARY KEY (id_oda));
CREATE SEQUENCE _id_odp_seq;
CREATE TABLE odp (
	id_odp integer NOT NULL DEFAULT nextval('_id_odp_seq'),
	data_odp date,
	codice_reparto varchar(15),
	note_odp text,
	CONSTRAINT pk_odp PRIMARY KEY (id_odp));
CREATE SEQUENCE _n_pas_seq;
CREATE TABLE fatturepas (
	n_pas integer NOT NULL DEFAULT nextval('_n_pas_seq'),
	fornitore varchar(15),
	data_pas date,
	note_pas text,
	scadenza date,
	registrata boolean DEFAULT false,
	pagata boolean DEFAULT false,
	n_fattura_fornitore text,
	CONSTRAINT pk_fatturepas PRIMARY KEY (n_pas));
CREATE SEQUENCE _id_seq;
CREATE TABLE pagamenti (
	id integer NOT NULL DEFAULT nextval('_id_seq'),
	data_pag date,
	fattura_pag integer,
	importo_pag numeric(15, 2),
	metodo_pag text,
	CONSTRAINT pk_pagamenti PRIMARY KEY (id));
ALTER TABLE pagamenti ADD CONSTRAINT "$1" FOREIGN KEY (fattura_pag) REFERENCES fatturepas(n_pas) ON DELETE RESTRICT ON UPDATE RESTRICT;
CREATE TABLE conti_base (
	codice_conto varchar(15) NOT NULL,
	descrizione_conto varchar(150),
	tipo_conto varchar(5),
	codice_gifi_conto varchar(15),
	categoria_conto varchar(5),
	CONSTRAINT pk_conti_base PRIMARY KEY (codice_conto));
CREATE SEQUENCE _id_pd_seq;
CREATE TABLE partita_doppia (
	id_pd integer NOT NULL DEFAULT nextval('_id_pd_seq'),
	data date,
	tipo_scrittura_pd text,
	documento_padre varchar(15),
	id_padre integer,
	dare_pd numeric(30, 4) DEFAULT 0,
	avere_pd numeric(30, 4) DEFAULT 0,
	conto_pd text DEFAULT 0,
	descrizione_movimento_pd text,
	id_fatt_pas integer,
	id_fatt_att integer,
	documento numeric(15, 3),
	CONSTRAINT pk_partita_doppia PRIMARY KEY (id_pd));
ALTER TABLE partita_doppia ADD CONSTRAINT "$1" FOREIGN KEY (conto_pd) REFERENCES conti_base(codice_conto) ON DELETE RESTRICT ON UPDATE RESTRICT;
CREATE SEQUENCE _n_seq;
CREATE TABLE fatture (
	"n" integer NOT NULL DEFAULT nextval('_n_seq'),
	cliente varchar(15),
	data date,
	note text,
	scadenza date,
	registrata boolean DEFAULT false,
	pagata boolean DEFAULT false,
	sconto numeric(15, 3) DEFAULT 0,
	CONSTRAINT pk_fatture PRIMARY KEY (n));
CREATE SEQUENCE _n_ddt_seq;
CREATE TABLE ddt (
	n_ddt integer NOT NULL DEFAULT nextval('_n_ddt_seq'),
	cliente varchar(15),
	data text,
	note text,
	interna boolean DEFAULT false,
	nome_vettore text,
	indirizzo_vettore text,
	citta_vettore text,
	aspetto_colli text,
	numero_colli numeric(10) DEFAULT 0,
	conf boolean DEFAULT false,
	fattura integer,
	causale varchar(30),
	CONSTRAINT pk_ddt PRIMARY KEY (n_ddt));
ALTER TABLE ddt ADD CONSTRAINT ddt_fattura_fkey FOREIGN KEY (fattura) REFERENCES fatture(n);
ALTER TABLE ddt ADD CONSTRAINT ddt_cliente_fkey FOREIGN KEY (cliente) REFERENCES persone(codice);
CREATE SEQUENCE _n_prev_ven_seq;
CREATE TABLE preventivi_ven (
	n_prev_ven integer NOT NULL DEFAULT nextval('_n_prev_ven_seq'),
	data_prev_ven date,
	cliente_prev_ven varchar(15),
	note_prev_ven text,
	scadenza_prev date,
	sconto_prev_ven numeric(15, 3) DEFAULT 0,
	confermato boolean DEFAULT false,
	bloccato boolean DEFAULT false,
	CONSTRAINT pk_preventivi_ven PRIMARY KEY (n_prev_ven));
ALTER TABLE preventivi_ven ADD CONSTRAINT "$1" FOREIGN KEY (cliente_prev_ven) REFERENCES persone(codice) ON DELETE RESTRICT ON UPDATE RESTRICT;
CREATE SEQUENCE _id_ric_seq;
CREATE TABLE riscossioni (
	id_ric integer NOT NULL DEFAULT nextval('_id_ric_seq'),
	data_ric date,
	fattura_ric integer,
	importo_ric numeric(15, 3),
	metodo_ric text,
	CONSTRAINT pk_riscossioni PRIMARY KEY (id_ric));
ALTER TABLE riscossioni ADD CONSTRAINT "$1" FOREIGN KEY (fattura_ric) REFERENCES fatture(n) ON DELETE RESTRICT ON UPDATE RESTRICT;
CREATE TABLE tipo_mov (
	codice_movimento varchar(5) NOT NULL,
	descrizione_movimento varchar(50) NOT NULL,
	testo_movimento text,
	CONSTRAINT pk_tipo_mov PRIMARY KEY (codice_movimento));
CREATE SEQUENCE _id_movimento_seq;
CREATE TABLE magazzino (
	id_movimento integer NOT NULL DEFAULT nextval('_id_movimento_seq'),
	data_movimento date NOT NULL,
	codice_magazzino varchar(15) NOT NULL,
	codice_mov_mage varchar(5) NOT NULL,
	qta_carico numeric(15, 3) DEFAULT 0,
	prezzo_acquisto numeric(15, 3) DEFAULT 0,
	qta_acquisto numeric(15, 3) DEFAULT 0,
	id_carico integer,
	bolla_carico integer,
	reparto_prod integer,
	qta_scarico numeric(15, 3) DEFAULT 0,
	preventivo integer,
	id_scarico integer,
	bolla_scarico integer,
	reparto_prel integer,
	note_magazzino text,
	data_ordine date,
	data_consegna_ordine date,
	ddt_carico_acq integer,
	fattura_ven integer,
	prezzo_vendita numeric(15, 2) DEFAULT 0,
	ddt_vendita integer,
	fattura_acq integer,
	ordine_acquisto integer,
	ordine_produzione integer,
	sconto_acquisto numeric(15, 2) DEFAULT 0,
	codice_iva_pas varchar(5),
	codice_iva_atv varchar(5),
	sconto_vendita numeric(15, 2) DEFAULT 0,
	qta_prev_ven numeric(15, 2) DEFAULT 0,
	fase_odp_carico integer,
	fase_odp_scarico integer,
	prev_qta_carico_pro numeric(15, 2) DEFAULT 0,
	prev_qta_scarico_pro numeric(15, 2) DEFAULT 0,
	CONSTRAINT pk_magazzino PRIMARY KEY (id_movimento));
ALTER TABLE magazzino ADD CONSTRAINT "$1" FOREIGN KEY (codice_magazzino) REFERENCES articoli(codice) ON DELETE RESTRICT ON UPDATE RESTRICT;
ALTER TABLE magazzino ADD CONSTRAINT "$2" FOREIGN KEY (ddt_carico_acq) REFERENCES ddt_fornitore(n_f) ON DELETE RESTRICT ON UPDATE RESTRICT;
ALTER TABLE magazzino ADD CONSTRAINT "$4" FOREIGN KEY (fattura_acq) REFERENCES fatturepas(n_pas) ON DELETE RESTRICT ON UPDATE RESTRICT;
ALTER TABLE magazzino ADD CONSTRAINT "$6" FOREIGN KEY (ddt_vendita) REFERENCES ddt(n_ddt) ON DELETE RESTRICT ON UPDATE RESTRICT;
ALTER TABLE magazzino ADD CONSTRAINT "$7" FOREIGN KEY (fattura_ven) REFERENCES fatture(n) ON DELETE RESTRICT ON UPDATE RESTRICT;
ALTER TABLE magazzino ADD CONSTRAINT "$8" FOREIGN KEY (fase_odp_carico) REFERENCES fase_odp(id_fase_odp) ON DELETE RESTRICT ON UPDATE RESTRICT;
ALTER TABLE magazzino ADD CONSTRAINT "$9" FOREIGN KEY (fase_odp_scarico) REFERENCES fase_odp(id_fase_odp) ON DELETE RESTRICT ON UPDATE RESTRICT;
ALTER TABLE magazzino ADD CONSTRAINT magazzino_codice_iva_atv_fkey FOREIGN KEY (codice_iva_atv) REFERENCES codici_iva(codice_iva);
ALTER TABLE magazzino ADD CONSTRAINT magazzino_codice_iva_pas_fkey FOREIGN KEY (codice_iva_pas) REFERENCES codici_iva(codice_iva);
ALTER TABLE magazzino ADD CONSTRAINT magazzino_ddt_vendita_fkey FOREIGN KEY (ddt_vendita) REFERENCES ddt(n_ddt);
ALTER TABLE magazzino ADD CONSTRAINT magazzino_fattura_ven_fkey FOREIGN KEY (fattura_ven) REFERENCES fatture(n);
ALTER TABLE magazzino ADD CONSTRAINT magazzino_fattura_acq_fkey FOREIGN KEY (fattura_acq) REFERENCES fatturepas(n_pas);
ALTER TABLE magazzino ADD CONSTRAINT magazzino_preventivo_fkey FOREIGN KEY (preventivo) REFERENCES preventivi_ven(n_prev_ven);
ALTER TABLE magazzino ADD CONSTRAINT magazzino_preventivo_fkey1 FOREIGN KEY (preventivo) REFERENCES preventivi_ven(n_prev_ven);
CREATE TABLE config (
	nome varchar(20) NOT NULL,
	valore text,
	tipo varchar(10),
	descrizione text,
	CONSTRAINT pk_config PRIMARY KEY (nome));
CREATE SEQUENCE _uid_seq;
CREATE TABLE users (
	uid integer NOT NULL DEFAULT nextval('_uid_seq'),
	username text NOT NULL,
	password text NOT NULL,
	lastlogin date,
	errorlogin integer DEFAULT 0,
	CONSTRAINT pk_users PRIMARY KEY (uid));
CREATE INDEX users_username_key ON users (username);
CREATE TABLE users_capabilities (
	uid integer NOT NULL,
	resource varchar(100) NOT NULL,
	perm integer DEFAULT 0
);
ALTER TABLE users_capabilities ADD CONSTRAINT users_capabilities_uid_fkey FOREIGN KEY (uid) REFERENCES users(uid) ON DELETE CASCADE;
CREATE SEQUENCE _gid_seq;
CREATE TABLE groups (
	gid integer NOT NULL DEFAULT nextval('_gid_seq'),
	groupname text NOT NULL,
	CONSTRAINT pk_groups PRIMARY KEY (gid));
CREATE INDEX groups_groupname_key ON groups (groupname);
CREATE TABLE groups_capabilities (
	gid integer NOT NULL,
	resource varchar(100) NOT NULL,
	perm integer DEFAULT 0
);
ALTER TABLE groups_capabilities ADD CONSTRAINT groups_capabilities_gid_fkey FOREIGN KEY (gid) REFERENCES groups(gid) ON DELETE CASCADE;
CREATE TABLE groups_users (
	gid integer NOT NULL,
	uid integer NOT NULL
);
ALTER TABLE groups_users ADD CONSTRAINT groups_users_gid_fkey FOREIGN KEY (gid) REFERENCES groups(gid) ON DELETE CASCADE;
ALTER TABLE groups_users ADD CONSTRAINT groups_users_uid_fkey FOREIGN KEY (uid) REFERENCES users(uid) ON DELETE CASCADE;
CREATE VIEW fatture_view AS 
    SELECT fatture.n, fatture.cliente, fatture.data, 
    sum(((magazzino.qta_scarico * magazzino.prezzo_vendita) * (1 - (magazzino.sconto_vendita / 100)) * (1 - (fatture.sconto / 100)))) AS imponibile, 
    sum((((((magazzino.qta_scarico * magazzino.prezzo_vendita) * (1 - (magazzino.sconto_vendita / 100))) * (1 - (fatture.sconto / 100))) * codici_iva.aliquota) / 100)) AS iva, 
    fatture.sconto, 
    sum((((magazzino.qta_scarico * magazzino.prezzo_vendita) * (1 - (magazzino.sconto_vendita / 100))) * (1 - (fatture.sconto / 100))) * (1 + (codici_iva.aliquota / 100))) AS totale
     FROM (fatture LEFT JOIN (magazzino JOIN codici_iva 
     ON ((magazzino.codice_iva_atv = codici_iva.codice_iva))) 
     ON ((fatture.n = magazzino.fattura_ven))) 
     GROUP BY fatture.n, fatture.data, fatture.cliente, fatture.sconto
  ;
CREATE VIEW preventivi_ven_view AS 
    SELECT  n_prev_ven, cliente_prev_ven,data_prev_ven, 
    sum(((magazzino.qta_prev_ven * magazzino.prezzo_vendita) * (1 - (magazzino.sconto_vendita / 100)) * (1 - (sconto_prev_ven / 100)))) AS imponibile, 
    sum((((((magazzino.qta_prev_ven * magazzino.prezzo_vendita) * (1 - (magazzino.sconto_vendita / 100))) * (1 - (sconto_prev_ven / 100))) * codici_iva.aliquota) / 100)) AS iva, 
    sconto_prev_ven,
    sum((((magazzino.qta_prev_ven * magazzino.prezzo_vendita) * (1 - (magazzino.sconto_vendita / 100))) * (1 - (sconto_prev_ven / 100))) * (1 + (codici_iva.aliquota / 100))) AS totale
     FROM (preventivi_ven LEFT JOIN (magazzino JOIN codici_iva 
     ON ((magazzino.codice_iva_atv = codici_iva.codice_iva))) 
     ON ((n_prev_ven = magazzino.preventivo))) 
     GROUP BY n_prev_ven, data_prev_ven, cliente_prev_ven, sconto_prev_ven
  ;
CREATE VIEW clienti AS 
    SELECT persone.codice, persone.nome, persone.indirizzo, persone.citta, persone.cap, persone.nazione, persone.pi, persone.tipo_pagamento, persone.dilazione, persone.banca, persone.cc, persone.iban, persone.contatto, persone.telefono, persone.fax, persone.email, persone.web, persone.f, persone.c, persone.note FROM persone WHERE (persone.c = true)
  ;
CREATE VIEW fornitori AS 
    SELECT persone.codice, persone.nome, persone.indirizzo, persone.citta, persone.cap, persone.nazione, persone.pi, persone.tipo_pagamento, persone.dilazione, persone.banca, persone.cc, persone.iban, persone.contatto, persone.telefono, persone.fax, persone.email, persone.web, persone.f, persone.c, persone.note FROM persone 
    WHERE (persone.f = true)
  ;
CREATE VIEW val_fatture_atv AS SELECT 
n,
cliente,
data,
scadenza,
registrata,
pagata,
id_movimento,
data_movimento,
codice_magazzino,
articoli.descrizione,
um,
conto_contabile,
codice_mov_mage,qta_scarico,
prezzo_vendita,
sconto_vendita,
aliquota,
(prezzo_vendita*(1-(sconto_vendita/100))) AS  prezzo_sc,
qta_scarico*(prezzo_vendita*(1-(sconto_vendita/100))) AS val_scarico,
(qta_scarico*(prezzo_vendita*(1-(sconto_vendita/100))))*(aliquota/100) AS val_iva,
(qta_scarico*(prezzo_vendita*(1-(sconto_vendita/100))))+((qta_scarico*(prezzo_vendita*(1-(sconto_vendita/100))))*(aliquota/100)) AS valore_sc_ivato,
conto_cont_acq,
conto_iva_c
FROM magazzino, fatture, articoli, codici_iva,articoli_tipi

WHERE fattura_ven=n
AND codice_magazzino=articoli.codice
AND codice_iva = codice_iva_pas
AND articoli_tipi.codice = tipo

;
CREATE VIEW val_fatture_pas AS 
SELECT 
n_pas,
n_fattura_fornitore,
fornitore,
data_pas,
scadenza,
registrata,
pagata,
id_movimento,
data_movimento,
codice_magazzino,
articoli.descrizione,
um,
conto_contabile,
codice_mov_mage,
qta_carico,
prezzo_acquisto,
sconto_acquisto,
aliquota,
(prezzo_acquisto*(1-(sconto_acquisto/100))) AS  prezzo_sc,
qta_carico*(prezzo_acquisto*(1-(sconto_acquisto/100))) AS val_carico,
(qta_carico*(prezzo_acquisto*(1-(sconto_acquisto/100))))*(aliquota/100) AS val_iva,
(qta_carico*(prezzo_acquisto*(1-(sconto_acquisto/100))))+((qta_carico*(prezzo_acquisto*(1-(sconto_acquisto/100))))*(aliquota/100)) AS valore_ca_ivato,
conto_cont_ven,
conto_iva_d
FROM magazzino, fatturepas, articoli, codici_iva,articoli_tipi

WHERE fattura_acq=n_pas
AND codice_magazzino=articoli.codice
AND codice_iva = codice_iva_pas
AND articoli_tipi.codice = tipo

;
CREATE VIEW contb_acquisto AS 

SELECT
n_pas AS documento,
'acquisto' AS descrizione,
data_pas as data,
conto_iva_d AS conto_contabile,
0 AS dare,
sum(val_iva) AS avere
FROM val_fatture_pas
GROUP BY n_pas, data_pas,conto_iva_d 

UNION

SELECT
n_pas AS documento,
'acquisto' AS descrizione,
data_pas as data,
conto_cont_ven AS conto_contabile,
0 AS dare,
sum(val_carico) AS avere
FROM val_fatture_pas
GROUP BY n_pas, data_pas,conto_cont_ven

UNION

SELECT
n_pas AS documento,
'acquisto' AS descrizione,
data_pas as data,
'220001' AS conto_contabile,
sum(valore_ca_ivato) AS dare,
0 AS avere
FROM val_fatture_pas
GROUP BY n_pas, data_pas

UNION

SELECT
fattura_pag AS documento,
'Pagamento Debito vs Fornitore' AS descrizione,
data_pag AS data,
metodo_pag AS conto_contabile,
0 AS dare,
importo_pag AS avere
FROM pagamenti

UNION

SELECT
fattura_pag AS documento,
'Pagamento Debito vs Fornitore' AS descrizione,
data_pag AS data,
'220001' AS conto_contabile,
importo_pag AS dare,
0 AS avere
FROM pagamenti
;
CREATE VIEW contab_gen AS 

SELECT 

documento,
descrizione,
data,
conto_contabile,
dare,
avere

FROM contb_acquisto

UNION

SELECT

documento,
descrizione,
data,
conto_contabile,
dare,
avere

FROM contb_vendite

UNION

SELECT

documento,
tipo_scrittura_pd AS descrizione,
data,
conto_pd AS conto_contabile,
dare_pd AS dare,
avere_pd AS avere

FROM partita_doppia
;
CREATE VIEW contb_vendite AS 
contb_vendite AS

SELECT
n AS documento,
'vendite' AS descrizione,
data,
conto_iva_c AS conto_contabile,
0 AS dare,
sum(val_iva) AS avere
FROM val_fatture_atv
GROUP BY n, data,conto_iva_c 

UNION

SELECT
n AS documento,
'vendite' AS descrizione,
data,
conto_cont_acq AS conto_contabile,
0 AS dare,
sum(val_scarico) AS avere
FROM val_fatture_atv
GROUP BY n, data,conto_cont_acq

UNION

SELECT
n AS documento,
'vendite' AS descrizione,
data,
'106001' AS conto_contabile,
sum(valore_sc_ivato) AS dare,
0 AS avere
FROM val_fatture_atv
GROUP BY n, data


UNION

SELECT
fattura_ric AS documento,
'Riscossione Crediti Clienti' AS descrizione,
data_ric AS DATA,
metodo_ric AS conto_contabile,
importo_ric AS dare,
0 AS avere
FROM riscossioni

UNION

SELECT
fattura_ric AS documento,
'Riscossione Crediti Clienti' AS descrizione,
data_ric AS DATA,
'106001' AS conto_contabile,
0 AS dare,
importo_ric AS avere
FROM riscossioni
;
CREATE VIEW vista_ragr_mov_mage AS 
SELECT 
magazzino.data_movimento, 
magazzino.codice_magazzino, 
(magazzino.qta_carico - magazzino.qta_scarico) AS giacenze, 0 AS acquistato, 
magazzino.qta_prev_ven AS preventivato FROM magazzino, 
preventivi_ven 
WHERE ((magazzino.preventivo = (preventivi_ven.n_prev_ven)::text) AND (preventivi_ven.confermato = true)) UNION SELECT magazzino.data_movimento, magazzino.codice_magazzino, (magazzino.qta_carico - magazzino.qta_scarico) AS giacenze, 0 AS acquistato, magazzino.qta_prev_ven AS preventivato FROM magazzino UNION SELECT magazzino.data_movimento, magazzino.codice_magazzino, 0 AS giacenze, 0 AS acquistato, magazzino.qta_prev_ven AS preventivato FROM magazzino WHERE ((magazzino.qta_carico = (0)::numeric) 
AND (magazzino.ordine_acquisto IS NOT NULL))
;
