// -*- Mode: C++ -*-
// Copyright (C) 2005 Aldo Nicolas Bruno

/*
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include <nhttpc.h>

xstring inputfile(const xstring & file)
{
  xstring a;
  int f=open( file.text() , O_RDONLY|O_LARGEFILE);
  if (f<0)
    {    
      perror("Error in open() call");
      return "";
    }
  xstring buff(2050);
  buff.setbinary(true);
  char *b=buff.getbuffer();

  while (1)
    {
      ssize_t r=read(f,b,2048); // XXX
      if(r==0) break;
      if (r<0)
	{
	  perror("error in read() call");
	  close (f);
	  return "";
	}

      buff.setlength(r);
      a+=buff;
    }
  return a;
}

int savefile (const xstring& file,const xstring& data)
{
  int r=0;
  int f=open( file.text() , O_RDWR|O_CREAT|O_EXCL|O_LARGEFILE);
  if(f<0) 
    {
      perror("savefile(): open64()");
      return f;
    }
  int x=write(f,data.text(),data.length());
  if(x<0) 
    perror("savefile(): write()");
  close(f);
  return x;
}

xstring input(const xstring & msg)
{
  cout << msg << ": "<< flush;

  char buff[256];
  fgets(buff,255,stdin);
  
  long l=xstring::xstrlen(buff,256);
  
  if(buff[l-1]=='\n') 
    buff[l-1]='\0';
  
  return xstring(buff);
}

xstring inputparagraph(const xstring& msg)
{
  cout << msg << " (press Ctrl-D to finish): "<< flush;
  xstring r;

  char buff[256];
  int i;
  do
    {
      i = read(0,buff,255);
      if(i>0)
	{
	  buff[i]=0;
	  r+=buff;
	}
    }while(i>0);

  long l=r.length();
  if(l>0 && r[l-1]=='\n') 
    r[l-1]='\0';
  
  return r;
}

int main(int argc , char** argv)
{
  xstring host=input("Host [localhost]");
  if(host.isempty()) host="127.0.0.1";
  
  xstring port=input("Port [8023]");
  long p=8023;
  if(port.notempty())
    p=port.getlong();

  HTTPClient  c (host,p);
  c.connect();
  if(c.getstatus()<0) 
    return 0;
		     
  xstringhash h;
  
  xstring m=input("Method [POST]");
  if(m.isempty()) m="POST";
  xstring r=input("Resource [/dbinterface]");
  if(r.isempty()) r="/dbinterface";

  xstring s;
  cout << "enter headers, press RETURN to finish" << endl; 
  do
    {
      s=input("");
      if(s.notempty())
	{
	  h.additemfromstring(s,':');
	}
      else
	break;

    }while (1);

  xstring data;
  if(m=="POST" || m=="PUT") 
    {
    selecterror:
      cout << "You selected a " << m << " method, select ([T]ext / File / None)";
      xstring i=input("");
      switch(i[0])
	{
	case '\0':
	case 'T':
	case 't':
	  data=inputparagraph("Insert text");
	  break;

	case 'F':
	case 'f':
	  data=inputfile(input("File Name"));
	  break;

	case 'N':
	case 'n':
	  data="";
	  break;

	default:
	  goto selecterror;
	}
     
    }
  
  if (c.getstatus()<0)
    return 0;

  HTTPCResource x = c.request(m,r,h,data);

  if(x.getstatus()<0) 
    return 0;
 
  xstring resp=x.getdata();
  time_t tv=x.getdate();

  cout  << "Resource successfuly received.\n" 
	<< "MIME Type: " << x.getmime() << endl
	<< "Size: " << resp.length() << " bytes.\n"
	<< "Date: " << ctime(& tv) << endl;

 selecterror2:
  if(resp.length()>0) 
    {
      cout << "What do you want to do with the data? ([V]iew / Save / None)" << flush;
      
      xstring wd= input("");
      
      switch (wd[0])
	{
	case 'V': case 'v': case '\0':
	  cout << resp << endl;
	  break;
	case 'S': 
	case 's':
	  {
	    xstring fname=input("File name");
	    int r = savefile(fname,resp);
	    
	    if (r<0)
	      goto selecterror2;
	  }
	  break;
	case 'N':
	case 'n':
	  break;
	default:
	  goto selecterror2;
	}
    }
  return 0;
}
