#! /usr/bin/env python

# Copyright (C) 2005 Aldo Nicolas Bruno

#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.

#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.

#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import sys 

# gtk stuff
import pygtk
pygtk.require('2.0')
import gtk
import gobject
from time import sleep
import socket

#import articoli

import gepal
import listview
import moddialog
import logindialog
import mainwindow
import listwindow
import amwindow
import message
import printdlg
import textview

from action import *

import os 
addr="localhost",8023

def parse_args():
    global addr

    ### TODO use module optparse instead of these!!!
    
    # parse cmd line options
    argv=sys.argv #[1:len(sys.argv)]
    # argv=[]
    l=len(argv)
    skip=True
    for i,s in enumerate (argv):
	if skip:
	    skip=False
	    continue
        
        if s == '--help' or s == '-h':
            print "This is GEPAL client Version " + gepal.version + " running on " + os.sys.platform + """
 
Command line options:
--help, -h     Show this help and exit
--version      Show version information and exit
--license      Show license information and exit
 
This program is under heavy development.
Report bugs to: gepal-list@nongnu.org
"""
            sys.exit(0)
        elif s == '--version':
            print """GEPAL client version " +gepal.version + " running on """ + os.sys.platform
            sys.exit(0)
            
        elif s == '--license' or s == '--licence':
            print """
This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
"""
            sys.exit(0)

            
	else:
	    print "error: unknown option `" + s + "'"
	    sys.exit(1)

def main():
    parse_args()

    server=gepal.Server(*addr)
    
    server.user="aldo"
    server.password="123"
    server.share=os.getcwd()+"/../share"
    server.sshuser=""#ospite"
    server.sshpassword=""#ospite"
    server.ssh=False
    
    
    while True:
        login=logindialog.LoginDialog(server,None)
        r=login.run()
        login.destroy()        
        if r != gtk.RESPONSE_OK:
            sys.exit(0)

        server.connect()

#        server.ui.addui("layout",layout.layout)
        server.ui.addui("mainwindow",mainwindow.mainwindow)
        server.ui.addui("listview",listwindow.listwindow)
        server.ui.addui("amwindow",amwindow.amwindow)
        server.ui.addui("message",message.message)
        server.ui.addui("print",printdlg.printdlg)
        server.ui.addui("textview",textview.textview)
        
        x=action(server,None,"main/menu")
        x.execute()
        if x:
            break
        
    gtk.main()
    
    server.disconnect()

if __name__== '__main__':
    
    main()

