# -*- shell-script -*-
# gfunc83111-size-analysis.sh -- Analyzes the size of a file, and-- if incorrect-- downloads the rest of the file
# Copyright © 2015-2016 Michael Pagan
#
# Author: Michael Pagan
# E-Mail: michael.pagan@member.fsf.org
# Jabber: pegzmasta@member.fsf.org
#
# This file is part of Genshiken.
#
# Genshiken is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# Genshiken is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Genshiken. If not, see http://www.gnu.org/licenses/.
#===================================================================
function Size_Analysis
{
  # Have genshiken check the file size from the server before downloading the file
  if [[ $3 = '--head' ]]; then Download_File $1 $2 $3

    # If the server gave genshiken the size information for the current file, then report that size to the user (I will format it to match wget's output)
    [[ -z $python_domain && ! -z ${Specified_Size:-} ]] &&
    Specified_Size=${Specified_Size:+$(gawk '{ print $1 }' <<< $Specified_Size)}
    Specified_Size=${Specified_Size:+$(gawk 'BEGIN { print '${Specified_Size//[^0-9.]/}' / 1024 / 1024 }' | gawk '{ printf "%.2f\n", $1 }')}

    # Ensure we do not fail in our attempt to get the size of the file
    while [[ ${Specified_Size} = 0 ]]
    do Download_File $1 $2 $3
      [[ -z $python_domain && ! -z ${Specified_Size:-} ]] &&
      Specified_Size=${Specified_Size:+$(gawk '{ print $1 }' <<< $Specified_Size)}
      Specified_Size=${Specified_Size:+$(gawk 'BEGIN { print '${Specified_Size//[^0-9.]/}' / 1024 / 1024 }' | gawk '{ printf "%.2f\n", $1 }')}
    done
    # Report the file size to the user
    local domain=${selected_domain:-$python_domain}
    echo -e "${N}${R}[${FUNCNAME[0]}] ${G}The Server, ${C}${domain}${G}, reports file ${M}$1${G}'s size to be ${M}$Specified_Size ${G}Mib. ${Y}   \b\b"

  # If there is a specified size (specified by the server) for the file, then begin size analysis
  elif [[ -z $python_domain && ! -z ${Specified_Size:-} ]]; then
    local File_Size=$(wc -c < $1)

    # Analyze if the file is the correct size; if it's not: Continue the download from where we left off
    if [[ $File_Size != $Specified_Size ]]; then

      # Let's make the size human readable by converting it into megabytes
      File_Size=$(gawk 'BEGIN { print '${File_Size//[^0-9.]/}'  / 1024 / 1024 }' | gawk '{ printf "%.2f\n", $1 }')
      Specified_Size=${Specified_Size:+$(gawk '{ print $1 }' <<< $Specified_Size)}
      Specified_Size=${Specified_Size:+$(gawk 'BEGIN { print '${Specified_Size//[^0-9.]/}' / 1024 / 1024 }' | gawk '{ printf "%.2f\n", $1 }')}
      echo -e "${N}${R}[${FUNCNAME[0]}] ${A}${G}\"${M}$1${G}\`s\" file-size is (${M}$File_Size${G} Mib) instead of (${M}$Specified_Size${G} Mib) ${N} \b" >&2
      echo -e "${N}${R}[${FUNCNAME[0]}] ${G}Continuing the download from where we left off${Y}   \b\b" >&2
      while [[ ${size:=wrong} = 'wrong' ]]; do Download_File $1 $2 --continue

        # Re-evaluate the size; if it's the same as what's specified-- DONE; if not-- loop again
        File_Size=$(wc -c < $1)
        [[ $File_Size -eq $Specified_Size ]] && size=right
        Specified_Size=${Specified_Size:+$(gawk '{ print $1 }' <<< $Specified_Size)}
        Specified_Size=${Specified_Size:+$(gawk 'BEGIN { print '${Specified_Size//[^0-9.]/}' / 1024 / 1024 }' | gawk '{ printf "%.2f\n", $1 }')}
      done; echo -e "${N}${R}[${FUNCNAME[0]}] ${G}The file \"${M}$1${G}\" has reached the specified size of (${M}$Specified_Size${G}) ${N} \b\n"
    fi
  fi
}

# End:
# gfunc83111-size-analysis.sh ends here
