# -*- shell-script -*-
# gfunc83110-interrupted-downloads.sh -- Determine if a previous execution of genshiken was terminated during a download procedure.
# Copyright © 2015-2016 Michael Pagan
#
# Author: Michael Pagan
# E-Mail: michael.pagan@member.fsf.org
# Jabber: pegzmasta@member.fsf.org
#
# This file is part of Genshiken.
#
# Genshiken is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# Genshiken is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Genshiken. If not, see http://www.gnu.org/licenses/.
#===================================================================
function Interrupted_Downloads
{
  # Let's check to see if the download for this video was interrupted from a previous execution of genshiken
  [[ -f .last_video || ! -z ${CONTINUE:-} ]] &&
  {
    #  Ensure we reset the $CONTINUE variable, it should only be set whenever a     |
    #+ server error of 404/410 is detected (unrecognized address due to file move)  |
    if [[ ! -z ${CONTINUE:-} ]]; then

      # For some reason, the name of the file may have some extra words appended to it
      cd $last_dir
      [[ ! -f $2 ]] && episode_file=$(ls $2*) || episode_file=$2
      [[ ! -f $episode_file ]] && Download_File $episode_file $episode_link -source
      last_episode=$1

      # Discover whether we can parse the video link with free software; provide as much detail as possible
      Extract_Information $2

      # Determine the server path to the video, and if we can't: Report back to the user
      last_server_path[0]=$(grep "${python_domain:-file}" $episode_file | $([[ -n ${selected_domain:-} ]] && echo "grep $selected_domain" ||
                            echo "grep '.*'") | sed -e 's_.*src="\(.*\)"_\1_' -e 's_".*__' -e 's_>__' -e 's_<.*>__g' $([[ -n $python_domain ]] &&
                            echo "-e s_.*file=\(.*\)_\1_") | eval $BROWSER_READABLE | sed -n '1 s/.*/&/p')
      unset CONTINUE
      # Inform the user that the file that we were about to download, has already been downloaded
      echo -e "\n${N}${R}[${FUNCNAME[0]}] ${G}\"${M}${last_episode}${G}\" has already been downloaded!? ${N}"
      echo -e "${N}${R}[${FUNCNAME[0]}] ${G}\"${M}${last_episode}${G}\" has a new network address; attempting to re-download ... ${N}"
    else
      # Retrieve the data of the last video that was interrupted
      { read last_episode; read last_server_path; } < .last_video

      # Inform the user that the file that we were about to download, has already been downloaded
      echo -e "\n${N}${R}[${FUNCNAME[0]}] ${G}\"${M}${last_episode}${G}\" has already been downloaded!? ${N}"
    fi
    # Download this episode only if it was interrupted from a previous download
    [[ $1 = $last_episode ]] && { [[ ! -z ${WAIT:-} && $WAIT -le 1 ]] && : || sleep 1; } &&
    {
      # Make a header request with the URL of the last video that was downloaded, in order to get the size information
      echo -e "${N}${R}[${FUNCNAME[0]}] ${A}${G}The video \"${M}$last_episode${G}\" was not fully downloaded, due to an interruption in program flow. ${N}" >&2
      if [[ -f .last_video ]]; then
          # Capture the last upload path
          server_path[0]=$last_server_path; Retrieve_Video_Link 0 0
          last_upload_path=${upload_path[0]}
      else
        # Set-up a `.last_video' file in case this function, which handles interruptions, gets interrupted
        echo $last_episode      > .last_video
        echo $last_server_path >> .last_video

        # Capture the last upload path
        server_path[0]=$last_server_path; Retrieve_Video_Link 0 0
        last_upload_path=${upload_path[0]}
      fi
      Download_File $last_episode $last_upload_path --head

      # Let's save the users' current anime of choice in a log file for processing later on
      [[ ! -f $DIR_DET/../previous-session-${MAIN//-/}-${$}-$RAND.log ]] &&
      echo "$(echo $title; echo $(< $DIR_DET/../last_choice.log); echo $MAIN $BASE_DIR)" > $DIR_DET/../previous-session-${MAIN//-/}-${$}-$RAND.log

      # If there is no size information inside the header, then download the file from scratch.
      [[ -z ${Specified_Size:-} ]] &&
      {
        echo -e "\n${N}${R}[${FUNCNAME[0]}] ${G}Can't verify the size integrity.  Downloading this episode again from scratch.${Y}   \b\b"
        rm $last_episode; Download_File $last_episode $last_upload_path; rm .last_video; return
      } ||
      {
        sleep 5
        #  Determine if the video is of the correct size or not, and if it's not                            |
        #+ the correct size: Continue the download from where we left off, and resume regular program flow. |
        echo -e "\n${N}${R}[${FUNCNAME[0]}] ${G}Analyzing size integrity ... ${N}"; [[ ! -z ${WAIT:-} && $WAIT -le 1 ]] && : || sleep 3
        Size_Analysis $last_episode $last_upload_path; rm .last_video; return
      }
    } ||
    # This episode was downloaded just fine
    { echo -e "${N}${R}[${FUNCNAME[0]}] ${G}Moving on to the next episode ${N}"; return; }
  }
}

# End:
# gfunc83110-interrupted-downloads.sh ends here
