# -*- shell-script -*-
# vfunc3-view-anime.sh -- View any manga series that you've downloaded thus far with Genshiken
# Copyright © 2015-2016 Michael Pagan
#
# Author: Michael Pagan
# E-Mail: michael.pagan@member.fsf.org
# Jabber: pegzmasta@member.fsf.org
#
# This file is part of Genshiken.
#
# Genshiken is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# Genshiken is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Genshiken. If not, see http://www.gnu.org/licenses/.
#===================================================================
function View_Manga
{
  # Setup a few basic variables
  CAT_NUM=$(ls | wc -l); [[ $CAT_NUM != 1 ]] && MENU=$(ls * | eval $BULLETIN) || MENU=$(ls | sed 's|/||' && ls * | eval $BULLETIN)
  old=$(grep + <<< "$MENU"| sed -e 's_.*[ ]__' -e 's/[,&:]/\\&/g') final=$(wc -l <<< "$old")

  # Collect all the old titles, and then enumerate them
  for ((i=$first; i<=$final; i++)); do old_title[$i]=$(sed -n "$i s_.*_&_p" <<< "$old"); done
  for ((i=$first; i<=$final; i++)); do MENU=$(sed "s|+ ${old_title[$i]}$| + $i) ${old_title[$i]}|" <<< "$MENU"); done

  # Display the menu and prompt for the requested  series
  echo -e "\n${N}${R}[${FUNCNAME[0]}] ${G}You've chosen to view all the ${M}$1${G} you've downloaded so far with \"${B}$PROGNAME ${G}\". ${N}"
  echo -e "${N}${R}[${FUNCNAME[0]}] ${G}To exit @ anytime, press: ${M}C-c ${N}"
  echo -e "${N}${R}[${FUNCNAME[0]}] ${G}The pager will display all your ${M}$1${G}. ${N} \b"
  echo -e "${N}${R}[${FUNCNAME[0]}] ${G}Just pick a number, press ${M}Q${G}, and enter the number @ the prompt:${Y}   \b\b"
  [[ ! -z ${WAIT:-} && $WAIT -le 2 ]] && : || sleep 6
  while [[ $? -lt 2 ]]
  do echo -e "${Y}  \b\b"; $PAGE <<< "$MENU"; echo
     echo -en "\b\b${N}${R}[${FUNCNAME[0]}] ${G}Which ${M}$1${G} series would you like to view:${Y}   \b\b"; read
    [[ $PAGE != less ]] && echo

    # Only process the request if the response is valid.
    while [[ $processing = 1 ]]
    do
      # Ensure the input contains no letters (makes sense, if we're only looking for title #'s)
      if [[ -z `grep -s '[0-9]' <<< $REPLY | grep -v '[^0-9]'` && $REPLY -eq 0 || $REPLY -ge `expr $final + 1` ]]; then
        echo -e "${N}${R}[${FUNCNAME[0]}] ${A}${G}Wrong character; choose a number from 1-${M}$final${G}! ${N} \b"; echo; sleep 3; continue 2
        echo -en "${N}${R}[${FUNCNAME[0]}] ${G}Select a valid series:${Y}   \b\b"; read; [[ $PAGE != less ]] && echo
      else
        # If the response is valid, then continue normal program flow.
        DIR_TITLE=$(grep "[ ]$REPLY)" <<< "$MENU" | sed -e 's_.*[ ]__')
        [[ ! -z ${DIR_TITLE:-} ]] && processing=0
      fi
    done

    # Determine the manga location
    CAT_VECT=$(sed -n '/:$/ N; { /\n.*/ s/).*//g p }' <<< "$MENU" | sed -n '/:$/ N; { s/\n.*+.//g p }') # VECT=CATEGORY:POSITION"

    # Which category does their choice fall under?
    [[ $CAT_NUM != 1 ]] &&
    {
      for ((i=$first;i<=$CAT_NUM; i++))
      do
        THIS_CAT=$(sed -n "$i s/.*/&/p" <<< "$CAT_VECT" | sed 's_.*:__')            # capture the position of the current category
        NEXT_CAT=$(sed -n "`expr $i + 1` s/.*/&/p" <<< "$CAT_VECT" | sed 's_.*:__') # capture the position of the next category

        # If the users' choice passes, then evaluate the name of the current category.
        if [[ $i = $CAT_NUM ]]; then
          DIR_CAT=$(sed -n "$i s/.*/&/p" <<< "$CAT_VECT" | sed 's_:.*__'); break
        else
          if [[ $REPLY -ge $THIS_CAT ]] && [[ $REPLY -lt $NEXT_CAT ]]
          then DIR_CAT=$(sed -n "$i s/.*/&/p" <<< "$CAT_VECT" | sed -e 's_:.*__'); break
          fi
        fi
      done
    } || DIR_CAT='*'

    # Ask the user if they would like to see the manga in slideshow mode (full screen has already been set)
    echo -e "${N}${R}[${FUNCNAME[0]}] ${G}You selected the ${M}$1${G}: \"${M}$DIR_TITLE${G}\"; To exit \"${M}$IMAGER${G}\", press: ${M}M-F4 ${N}"
    echo; echo -en "${N}${R}[${FUNCNAME[0]}] ${G}Would you like to view the ${M}$1${G} in slideshow mode? (Y/*):${Y}   \b\b"; read; [[ $PAGE != less ]] && echo
    case $(sed y/y/Y/ <<< $REPLY) in
      Y) $MSG "Now viewing: \"$DIR_TITLE\" ..."; $IMAGER -f -s $DIR_PICS/$DIR_CAT/$DIR_TITLE/;; # Slideshow
      *) $MSG "Now viewing: \"$DIR_TITLE\" ..."; $IMAGER -f    $DIR_PICS/$DIR_CAT/$DIR_TITLE/;; # Fullscreen
    esac
    # Once the user has finished, prompt them if they would like to continue.
    echo -en "${N}${R}[${FUNCNAME[0]}] ${G}Would you like to continue? (Y/*):${Y}   \b\b"; read
    [[ $(sed 'y/y/Y/' <<< $REPLY) = 'Y' ]] && continue || exit 0
  done
}

# End:
# vfunc3-view-anime.sh ends here
