# -*- shell-script -*-
# vfunc1-watch-anime.sh -- Watch any anime series that you've downloaded thus far with Genshiken
# Copyright © 2015-2016 Michael Pagan
#
# Author: Michael Pagan
# E-Mail: michael.pagan@member.fsf.org
# Jabber: pegzmasta@member.fsf.org
#
# This file is part of Genshiken.
#
# Genshiken is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# Genshiken is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Genshiken. If not, see http://www.gnu.org/licenses/.
#===================================================================
function Watch_Anime
{
  # Setup a few basic variables
  MENU=$(ls ? | eval $BULLETIN) old=$(grep + <<< "$MENU" | sed -e 's_.*[ ]__' -e 's/[,&:]/\\&/g') final=$(wc -l <<< "$old")

  # Collect all the old titles, and then enumerate them
  for ((i=$first; i<=$final; i++)); do old_title[$i]=$(sed -n "$i s_.*_&_p" <<< "$old"); done
  for ((i=$first; i<=$final; i++)); do MENU=$(sed "s|+ ${old_title[$i]}$| + $i) ${old_title[$i]}|" <<< "$MENU"); done

  # Display the menu and prompt for the requested anime series
  echo -e "\n${N}${R}[${FUNCNAME[0]}] ${G}You've chosen to view all the ${M}$1${G} you've downloaded so far with \"${B}$PROGNAME${G}\". ${N}"
  echo -e "${N}${R}[${FUNCNAME[0]}] ${G}To exit at anytime, press: ${M}C-c ${N}"
  echo -e "${N}${R}[${FUNCNAME[0]}] ${G}The pager will display all your ${M}$1${G}. ${N} \b"
  echo -e "${N}${R}[${FUNCNAME[0]}] ${G}Just pick a number, press ${M}Q${G}, and enter the number at the prompt:${Y}   \b\b"
  [[ ! -z ${WAIT:-} && $WAIT -le 2 ]] && : || sleep 6
  while [[ $? -lt 2 ]]
  do echo -e "${Y}  \b\b"; $PAGE <<< "$MENU"; echo
     echo -en "\b\b${N}${R}[${FUNCNAME[0]}] ${G}Which ${M}$1${G} series would you like to play:${Y}   \b\b"; read
    [[ $PAGE != less ]] && echo

    # Only process the request if the response is valid.
    while [[ $processing = 1 ]]
    do
      # Ensure the input contains no letters (makes sense, if we're only looking for title #'s)
      if [[ -z `grep -s '[0-9]' <<< $REPLY | grep -v '[^0-9]'` && $REPLY -eq 0 || $REPLY -ge `expr $final + 1` ]]; then
        echo -e "${N}${R}[${FUNCNAME[0]}] ${A}${G}Wrong character; choose a number from 1-${M}$final${G}! ${N} \b"; echo
        [[ ! -z ${WAIT:-} && $WAIT -le 1 ]] && : || sleep 3
        continue 2
        echo -en "${N}${R}[${FUNCNAME[0]}] ${G}Select a valid series:${Y}   \b\b"; read; [[ $PAGE != less ]] && echo
      else
        # If the response is valid, then continue normal program flow.
        DIR_TITLE=$(grep "[ ]$REPLY)" <<< "$MENU" | sed -e 's_.*[ ]__')
        [[ ! -z ${DIR_TITLE:-} ]] && processing=0
      fi
    done
    CHOICE=$REPLY

    # Determine the anime location (Assumption: The category directory is the first letter of the anime title)
    DIR_CAT=$(sed 's_\(.\).*_\1_' <<< $DIR_TITLE | grep '[A-Z]'); [[ -z ${DIR_CAT:-} ]] && DIR_CAT='#'

    # The above assumption may be wrong, so test to see if the anime exists in this directory.
    [[ ! -d $DIR_ANIM/$1/$DIR_CAT/$DIR_TITLE/ ]] &&
    { for CHAR in { A B C D E F G H I J K L M N O P Q R S T U V W X Y Z }; do [[ -d $DIR_ANIM/$1/$CHAR/$DIR_TITLE/ ]] && DIR_CAT=$CHAR && break; done; }
    echo -e "\n${N}${R}[${FUNCNAME[0]}] ${G}You selected the ${M}$1${G}: \"${M}$DIR_TITLE${G}\" ${N} \b"

    # If the user has not finished downloading this series, then let them know about it and prompt to continue or not
    if [[ -f $DIR_ANIM/$1/$DIR_CAT/$DIR_TITLE/.last_video ]] ||
       [[ `find $DIR_DET/../ -name 'previous-session-get-*' -type f -print | xargs grep "$DIR_TITLE" | gawk -F: '{ print $2 }'` = $DIR_TITLE ]]
    then
      echo -en "${N}${R}[${FUNCNAME[0]}] ${G}It appears you haven't finished downloading this series.  Would you like to continue anyway? (Y/*):${Y}   \b\b"
      read; [[ $(sed 'y/y/Y/' <<< $REPLY) != 'Y' ]] && exit 0
    fi
    # Commence signature countdown (you'll know it)
    echo -e "\n${N}${R}[${FUNCNAME[0]}] ${G}Now playing \"${M}$DIR_TITLE${G}\" ...\n ${N}"
    echo -e "${N}${R}[${FUNCNAME[0]}] ${G}Terminate this video and play the next, by entering one of the following keys: ${M}q${G}/${M}C-q${G}/${M}M-F4 ${N}"
    echo -e "${N}${R}[${FUNCNAME[0]}] ${G}To terminate the playlist, switch back to your console (M-Tab), and press: ${M}C-c ${N}"
    [[ ! -z ${WAIT:-} && $WAIT -le 1 ]] && : || sleep 5
    for i in {5..0}; do [[ $i -eq 0 ]] && TOONAMI || { echo; echo -e "\t${Y}$i  \b"; [[ ! -z ${WAIT:-} && $WAIT -le 1 ]] && : || sleep 1; }; done

    # Play the anime series
    $MSG "Now playing: \"$DIR_TITLE\" ..."; cd $DIR_ANIM/$1/$DIR_CAT/$DIR_TITLE/
    [[ ! -z `ls | egrep -v 'ogg|mp4|avi|flv'` ]] && rm $(ls | egrep -v 'ogg|mp4|avi|flv') # Remove any temporary files if there are any ...
    last=$(ls -ltr | egrep -v '\.$|total' | gawk '{ print $9 }' | wc -l)
    [[ $START_AT = 'latest' ]] && START_AT=$last LATEST=true
    [[ $START_AT != 0 ]] && first=$START_AT

    for ((l=$first; l<=$last; l++))
    do
      # Let's save the users' current anime of choice in a log file for processing later on
      [[ ! -f $DIR_DET/../previous-session-${MAIN//-/}-${$}-$RAND.log ]] &&
      { echo "$(echo $DIR_TITLE; echo ${CHOICE}+$l; echo $MAIN $BASE_DIR)" > $DIR_DET/../previous-session-${MAIN//-/}-${$}-$RAND.log; } ||
      sed -i "s_\([1-9]*\)+.*_\1+${l}_" $DIR_DET/../previous-session-${MAIN//-/}-${$}-$RAND.log

      [[ ! -f $DIR_DET/../last_choice.log ]] && echo        "$(echo ${CHOICE}+$l)" > $DIR_DET/../last_choice.log ||
                                                sed -i s_.*_"$(echo ${CHOICE}+$l)"_  $DIR_DET/../last_choice.log

                   NEXT_VIDEO=$(ls -ltr | egrep -v '\.$|total' | gawk '{ print $9 }' | sed -n "$l s/.*/&/p")
      eval $($MSG $NEXT_VIDEO) & # Background this message process, so we can play videos without the wait ...
          $PLAYER $NEXT_VIDEO; [[ ! -z ${WAIT:-} && $WAIT -le 1 ]] && : || sleep 1
    done

    #  If we are inside the genshiken here-doc, we will have reached this point                |
    #+ after finishing the last episode.  If that's the case, then the restored session is now |
    #+ complete, and the associated session file should now be removed.                        |
    if [[ -f $TMPDIR/genshiken-$USER/.genshiken-here-doc.$(basename $SHELL) ]]; then
      echo -e "${N}${R}[${FUNCNAME[0]}] ${G}Your restored session is now complete.  Removing associated session file ... ${N} \b"
      [[ ! -z ${WAIT:-} && $WAIT -le 1 ]] && : || sleep 1
      [[ -f $DIR_DET/../previous-session-${MAIN//-/}-${$}-$RAND.log ]] && rm $DIR_DET/../previous-session-${MAIN//-/}-${$}-$RAND.log
      [[ -f $RESTORE.backup ]] && rm $RESTORE.backup
      read # This script is automated at this point, and doesn't need an interactive prompt like below; thus, `read` stands alone
      exit # The users' session is now complete
    else

      # Ensure we reset the $START_AT variable, in case we loop again
      [[ ! -z ${LATEST:-} ]] && START_AT=latest

      # Ensure we reset the $DIR_TITLE and processing variable, in case we loop again
      DIR_TITLE= processing=1

      # We will remove this current session file, now that we're done with it
      rm $DIR_DET/../previous-session-${MAIN//-/}-${$}-$RAND.log

      # Once the user has finished, prompt them if they would like to continue.
      echo -en "${N}${R}[${FUNCNAME[0]}] ${G}Would you like to continue? (Y/*):${Y}   \b\b"; read
      [[ $(sed 'y/y/Y/' <<< $REPLY) = 'Y' ]] && continue || exit 0
    fi
  done
}

# End:
# vfunc1-watch-anime.sh ends here
