# -*- shell-script -*-
# gfunc83000-download-anime.sh -- Determine the users' selected anime of choice; process the arguments; send them to 'Extract_Files'
# Copyright © 2015-2016 Michael Pagan
#
# Author: Michael Pagan
# E-Mail: michael.pagan@member.fsf.org
# Jabber: pegzmasta@member.fsf.org
#
# This file is part of Genshiken.
#
# Genshiken is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# Genshiken is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Genshiken. If not, see http://www.gnu.org/licenses/.
#===================================================================
function Download_Anime
{
  # Determine what choice the user made in the [Anime Prompt]
  local input=$(sed 's_\(.*\)\[.*_\1_' < choice_) chr=$(sed 's_.*\[\(.*\)|.*_\1_' < choice_) lwr=$(sed 's_.*|\(.*\)].*_\1_' < choice_)

  # Determine the name of the $Anime_Page for this specific anime
  if [[ "$lwr" = '.*' ]]
  then local Anime_Page=$(grep -n "[$chr].*"      series_1.txt    | grep "^$input" | sed 's_.*"\(.*\)" title.*>.*_\1_') chr='#'
  else local Anime_Page=$(grep -n "[$chr|$lwr].*" series_$chr.txt | grep "^$input" | sed 's_.*"\(.*\)" title.*>.*_\1_')
  fi; mv choice_ $DIR_DET/../last_choice.log

  # Determine the name of the webpage file, and download the $Anime_Page to that file
  File=$(sed 's_.*/anime/\(.*\)_\1_' <<< "$Anime_Page")
  if [[ $1 = 'movie' || $1 = 'ova' && $File = $Anime_Page ]]
  then unset File && File=$(sed 's_.*/\(.*\)_\1_; s/ /_/g' <<< "$Anime_Page") # The Anime-Types 'movie|ova' have only one dividing forward slash on their pages ...
  fi; Download_File $File $Anime_Page -source

  # Ensure we are online and on the correct page                        |
  # NOTE: (OVA's will have the string 'English ?ubbed' within the name) |
  [[ -z `grep "${Selected_Anime//English ?ubbed}" $File` ]] &&
  { echo -e "\n${N}${R}[${FUNCNAME[0]}] ${A}${G} Internet Connection Lost!  Exitting now..."; mv $RESTORE.backup $RESTORE; exit 10; }

  # If we are on an ova series, then let's grab the cover page, instead of working on the first episode page                            |
  # NOTE: This procedure doesn't need to be executed on the Anime-Type 'movie', for the first episode page is all we need for that one. |
  if [[ $1 = 'ova' ]]; then
    Anime_Page=$(grep 'category tag' $File | sed 's_.*href=.\(.*\).[ ]r.*_\1_')
    Download_File $File $Anime_Page -source
  fi
  # If the user simply requested a description, then retrieve it from the anime page and return to the calling function [Anime_Prompt].
  [[ ${2//-/} = 'Describe' ]] &&
  {
    tr -cd '\11\12\15\40-\176' < $File > clean-file; rm $File; mv clean-file $File
    img_url=$(grep 'image_src' $File | gawk -F"<" '{ print $2}' | sed 's_.*href=.\(.*\)".*_\1_')
    ext=$(sed 's_.*\.\(.*$\)_\1_' <<< $img_url)
    img_file=preview_pic.$ext

    # Extract the description from the episode cover page
    if [[ $1 = 'movie' ]]; then
      intro=$(grep 'span' $File | sed -e 's_.span.id.*__' -e 's_.*</b>__' -e 's_<br./>__' -e '/span/,$ d' |\
              eval $(sed "s:........\.....::" <<< "$HUMAN_READABLE"))
    else
      intro=$(grep 'iltext' $File | grep -v 'td class' | sed -e 's_.*>\(.*\)<.*_\1_' | eval $(sed "s:........\.....::" <<< "$HUMAN_READABLE"))
      [[ -z ${intro:-} || $intro = 'Plot Summary:' ]] &&
      intro=$(grep 'iltext' $File | grep -v 'td class' | gawk -F'>' '{ print $3 }' | sed -e 's_/p__' -e 's_<br./__' |\
              eval $(sed "s:........\.....::" <<< "$HUMAN_READABLE"))
      [[ $intro = 'Plot Summary:' ]] && intro=$(sed -n '/Plot Summary:/,/div/ p' $File | sed -e 's_<.*>__' -e '1 d' -e '$ d' |\
                                                eval $(sed "s:........\.....::" <<< "$HUMAN_READABLE"))
    fi
    # Display the description
    echo -e "\n${Y}$intro  \b\n"; wget $img_url -O $img_file; [[ -f $img_file ]] && { $IMAGER $img_file; rm $img_file; }
    rm $File; unset img_url ext img_file intro
    return
  }
  # Remove all non-ascii characters from this file for proper text processing
  sed -i 's/—/--/g' $File # Let's replace the unicode dash with a double-dash
  tr -cd '\11\12\15\40-\176' < $File > clean-file; rm $File; mv clean-file $File; File1="$File-links.txt"

  # Determine the name of the anime
  local Anime=$(cat $File | grep '<title>' | sed -e 's_.*>\(.*\).|.*_\1_' -e 's:[ ]:_:g' -e 's_amp;__g' -e 's:.[Ee]nglish.[Dd]ubbed::g' | eval $HUMAN_READABLE)

  # Capture all the regular episode links into a file, for analysis (a new file will be created with all episodes in the correct order later) |
  # NOTE: The OVA/Specials pages have a similar HTML scheme as the Anime-Type 'movie', and will be treated as such                            |
  [[ -f $File1 ]] && rm $File1
  if [[ $1 != 'ova' && $1 != 'movie' ]]; then
    # Movies and OVA's are released on a per-episode basis and hence will not have a list; thus, the below sed script can not be applied to them
    sed -n '/CAT List START/,/CAT List FINISH/ { /bookmark/ s,.rel=.[a-z]*",,p }' $File |\
    sed -e '/[^>].$/ N; s/\n//' -e 's:</li>[ ]*<li>:</li>\n     <li>:' | eval $EPISODE_LINKS | eval $HUMAN_READABLE_2 > $File1
  elif [[ $1 = 'movie' ]]; then
    sed -n '/Episode.List/,$ p' $File | egrep '<li><a.*[ ]title=".*|.*</a></li>'  | eval $EPISODE_LINKS | eval $HUMAN_READABLE_2 | grep ${Anime//[ ]/_} > $File1
  else
    grep '<li><a.*[ ]title=.*rel=.*>.*</a></li>' $File | sed -e '/[^>].$/ N; s/\n//' -e 's:</li>[ ]*<li>:</li>\n     <li>:' |\
    eval $EPISODE_LINKS | eval $HUMAN_READABLE_2 | egrep '[Ss]pecial|OVA' > $File1
  fi
  # Add all episode links to a new file in the correct order
  if [[ $1 != 'movie' && $1 != 'ova' ]]; then

    # We need a sorting routine that deals with animes that have more than 1 season, and have been uploaded in the wrong order. |
    #                                                                                                                           |
    # NOTE: This type of occurance is highly unlikely, but still exists for certain anime.                                      |
    #       The title string will appear as: 'Anime_Title [Season #] Episode'                                                   |
    #       I don't have a condition that checks whether each season is in the right order or not; instead,                     |
    #+      I simply attempt to put them in the right order, whether they already are or not. ==================================/
    if [[ ! -z `grep '[2]_Episode' $File1` ]]; then
      for i in {1..9}
      do
        if [[ $i = 1 ]]; then
          season_number='^2-9'
          grep "[$season_number]_Episode" $File1 >> $File1-FIX

          # Is the last link in the compiled list episode 1-- if so, then this list is in reverse order
          local Last_Episode=$(sed -n '$ p' < $File1-FIX | sed -e 's_.*\(.\).$_\1_')
          [[   $Last_Episode != $first && ! -z `sed -n '$ p' $File1-FIX | egrep 'Episode_1_|episode\-1\-'` ]] && Last_Episode=$first

          # If our list is reversed, then we'll pipe to tac; if not-- to tee
          [[ $Last_Episode = $first ]] && local ORDER=tac || local ORDER=tee
          cat $File1-FIX | $ORDER > $File1-FIX-2; rm $File1-FIX; mv $File1-FIX-2 $File1-FIX
        else
          season_number=$i; [[ -z `grep "[$season_number]_Episode" $File1` ]] && break
          grep "[$season_number]_Episode" $File1 | $ORDER>> $File1-FIX
        fi
      done
      rm $File1; mv $File1-FIX $File1

    # This series has only 1 season (NOTE: I am not checking for series that enumerate their seasons with Roman Numerals-- way too tricky!)
    else
      # Is the last link in the compiled list episode 1-- if so, then this list is in reverse order
      local Last_Episode=$(sed -n '$ p' < $File1 | sed -e 's_.*\(.\).$_\1_')
      [[   $Last_Episode != $first && ! -z `sed -n '$ p' $File1 | egrep 'Episode_1_|episode\-1\-'` ]] && Last_Episode=$first

      # If our list is reversed, then we'll pipe to tac; if not-- to tee
      [[ $Last_Episode = $first ]] && local ORDER=tac || local ORDER=tee
      cat $File1 | $ORDER > $File1-FIX; rm $File1; mv $File1-FIX $File1
    fi

  # Let's sort the Specials, as well
  elif [[ $1 = 'ova' ]]; then
      # Is the last link in the compiled list episode 1-- if so, then this list is in reverse order
      local Last_Episode=$(sed -n '$ p' < $File1 | sed -e 's_.*\(.\).$_\1_')
      [[   $Last_Episode != $first && ! -z `sed -n '$ p' $File1 | egrep 'Episode_1_|episode\-1\-'` ]] && Last_Episode=$first

      # If our list is reversed, then we'll pipe to tac; if not-- to tee
      [[ $Last_Episode = $first ]] && local ORDER=tac || local ORDER=tee
      cat $File1 | $ORDER > $File1-FIX; rm $File1; mv $File1-FIX $File1
  fi
  # Ensure that if we were told to get only special episodes, that we filter out anything that is a regular episode-- unless requested to ...                 |
  # NOTE: The very first condition is here, because of the existence of the anime "Special A", which just so happens to have the string "Special" in its name |
  if [[ $1 = 'ova' ]]; then
    if [[ -z `sed -n '1 p' $File1 | gawk -F'>' '{ print $1 }' | grep '^[Ss]pecial'` ]]; then

      # SCENARIO 1: There are a group of OVA's in the series
      [[ ! -z `egrep '[oO][vV][aA]|[Ss]pecial' $File1` ]] && egrep '[oO][vV][aA]|[Ss]pecial' $File1 > $File1-FIX && rm $File1 && mv $File1-FIX $File1 ||
      {
        # SCENARIO 2: The OVA is episode zero
        [[ ! -z `grep '\-0\-' $File1` ]] && sed -n '1 p' $File1 > $File1-FIX && rm $File1 && mv $File1-FIX $File1 ||
        {
          # If we're in the genshiken here-doc, then we don't need an interactive prompt
          if [[ -f $TMPDIR/genshiken-$USER/.genshiken-here-doc.sh ]]; then
            read; OVERRIDE='OVERRIDE'; rm $File1

            # The user has requested to see all episodes
            egrep '<li><a.*[ ]title=".*|.*</a></li>' $File | sed '/[^>].$/ N; s/\n//' | eval $EPISODE_LINKS | grep '^<' > $File1

            # Is the last link in the compiled list episode 1-- if so, then this list is in reverse order
            local Last_Episode=$(sed -n '$ p' < $File1 | sed -e 's_.*\(.\).$_\1_')
            [[   $Last_Episode != $first && ! -z `sed -n '$ p' $File1 | egrep 'Episode_1_|episode\-1\-'` ]] && Last_Episode=$first

            # If our list is reversed, then we'll pipe to tac; if not-- to tee
            [[ $Last_Episode = $first ]] && local ORDER=tac || local ORDER=tee
            cat $File1 | $ORDER > $File1-FIX; rm $File1; mv $File1-FIX $File1

          else
            echo -en "${N}${R}[${FUNCNAME[0]}] ${G}No Specials detected!  Continue ${M}${Streaming:-Downloading} ${G}this series anyway? (Y/*): ${Y}  \b\b"
            read; [[ $(sed 'y/y/Y/' <<< $REPLY) != 'Y' ]] && return || OVERRIDE='OVERRIDE'; rm $File1

            # The user has requested to see all episodes
            egrep '<li><a.*[ ]title=".*|.*</a></li>' $File | sed '/[^>].$/ N; s/\n//' | eval $EPISODE_LINKS | grep '^<' > $File1

            # Is the last link in the compiled list episode 1-- if so, then this list is in reverse order
            local Last_Episode=$(sed -n '$ p' < $File1 | sed -e 's_.*\(.\).$_\1_')
            [[   $Last_Episode != $first && ! -z `sed -n '$ p' $File1 | egrep 'Episode_1_|episode\-1\-'` ]] && Last_Episode=$first

            # If our list is reversed, then we'll pipe to tac; if not-- to tee
            [[ $Last_Episode = $first ]] && local ORDER=tac || local ORDER=tee
            cat $File1 | $ORDER > $File1-FIX; rm $File1; mv $File1-FIX $File1
          fi
        }
      }
    fi
  fi
  # We shall let the user know what kind of episode we're downloading, by comparing them to these lists.  If there's no match, then it's a regular episode.
  Specials_List=$(grep '<li><a.*[ ]title=.*rel=.*>.*</a></li>' $File | sed '/[^>].$/ N; s/\n//' | eval $EPISODE_LINKS |\
                  gawk -F'>' '{ print $2 }' | egrep '[Ss]pecial|OVA' | $ORDER)
  Movies_List=$(  grep '<li><a.*[ ]title=.*rel=.*>.*</a></li>' $File | sed '/[^>].$/ N; s/\n//' | eval $EPISODE_LINKS |\
                  gawk -F'>' '{ print $2 }' | egrep '[Mm]ovie'       | $ORDER)

  # Inform the user that we're about to extract all embedded videos inside each link in our episode links list file
  [[ -z $2 ]] && echo -e "\n${N}${R}[${FUNCNAME[0]}] ${G}The Anime Webpage is: ${R}<${C}$Anime_Page${R}> ${N}  \b"
  echo -e "${N}${R}[${FUNCNAME[0]}] ${G}Extracting all ${M}Episode${G} links in list: \"${M}$File1${G}\". ${N}  \b"
  episode_count=0; [[ $1 != 'movie' ]] && episode_total=$(wc -l < $File1) || episode_total=1

  # If the user requested to see the latest episode, then set the count to the last episode
  [[ $START_AT = 'latest' ]] && START_AT=$episode_total LATEST=true

  #  If Genshiken was interrupted by wget, when it received an Error Code of 404/410 from the server, |
  #+ then continue downloading the file from where we left off                                        |
  if [[ -f $DIR_DET/../.recalculate_address.log ]]; then
    last_dir=$(< $DIR_DET/../.recalculate_address.log)
    rm $DIR_DET/../.recalculate_address.log
    cd $last_dir
    Clean_Up directory
    START_AT=$(ls -ltr *\.* | wc -l) CONTINUE=true
    cd - 1> /dev/null
  fi
  # Extract all videos from each webpage in our links file
  for webpage in `< $File1`
  do
    # Skip episodes that we're not interested in, with a 'continue/return'
    let    episode_count+=1                                                 # Episode Number
    if [[ $episode_count -lt $START_AT ]]; then continue; fi
    if [[ $episode_count -gt $episode_total ]]; then return; fi             # All movies will be listed for the Anime-Type 'movie', but we only need 1
    local current_episode_page=$(sed 's_.*\..*/\(.*\)>.*_\1_' <<< $webpage) # The name of the page that contains our episode
    local current_episode_name=$(gawk -F'>' '{ print $2 }' <<< $webpage)    # The name of the episode-- unformatted (will fix later)

    # Announce the total number of web-links we've found
    if [[ $episode_total != 1 ]]; then
      if [[ $episode_count = 1 ]]
      then echo -e "${N}${R}[${FUNCNAME[0]}] ${G}There are a total of ${M}$episode_total${G} web-links in list: \"${M}$File-links.txt${G}\" ${N}  \b"
      fi
    else
      if [[ $episode_count = 1 ]]
      then echo -e "${N}${R}[${FUNCNAME[0]}] ${G}There is a total of ${M}1${G} web-link in list: \"${M}$File-links.txt${G}\" ${N}  \b"
      fi
    fi
    #  Figure out what type of episode this is (Regular?  Special?  Movie?), and then              |
    #+ send the collected arguments to 'Extract_Files', in order to download the current episode   |
    #                                                                                              |
    #  NOTE: Just in case episodes with similar names pop-up, I'll use `grep -x` for exact matches |
    [[ ! -z        `grep -x "$current_episode_name" <<< "$Specials_List"` ]] && TYPE=Special # An anime series <<may contain>> 'Specials'
    [[ $1 =                                                         'ova' ]] && TYPE=Special # The user requested 'Specials'-- period.
    [[ ! -z `gawk -F'>' '{ print $2 }' <<< $webpage | grep '^[Ss]pecial'` ]] && TYPE=        # The existence of the anime "Special A" makes this required
    [[ ! -z        `grep -x "$current_episode_name" <<<   "$Movies_List"` ]] && TYPE=Movie   # An anime series may contain 'Movies'
    [[ $1 =                                                       'movie' ]] && TYPE=Movie   # The user is watching a single movie.
    echo -e "\n${N}${R}[${FUNCNAME[0]}] ${G}Processing ${M}${TYPE:=Regular}${G} web-link ${M}$episode_count${G} of ${M}$episode_total${G}. ${N}  \b"
    Extract_Files $webpage $chr $Anime $episode_count $episode_total $1; unset  TYPE

    # Inform the user if this procedure has extracted THIS episode or not
    if [[ -f missing_files.log ]]
    then
      Missed_Episode=$(grep $episode_link missing_files.log)
      if [[ -z ${Missed_Episode:-} ]]
      then
        echo -e "${N}${R}[${FUNCNAME[0]}] ${G}Finished extracting \"${M}$current_episode_page${G}\" ==FROM== \"${M}$File-links.txt${G}\" ${N}  \b"
      else
        echo -e "${N}${R}[${FUNCNAME[0]}] ${G}The Video \"${M}${episode_name[0]}${G}\" was SKIPPED!  Couldn't find any ethical hosts. ${N}"
        [[ ! -z ${WAIT:-} && $WAIT -le 1 ]] && : || sleep 5
      fi
    else
      echo -e "${N}${R}[${FUNCNAME[0]}] ${G}Finished extracting \"${M}$current_episode_page${G}\" ==FROM== \"${M}$File-links.txt${G}\" ${N}  \b"
    fi
  done

  # Inform the user if this procedure has extracted ALL episodes or not (SKIP if the Anime-Type equals 'movie', which has only 1 episode)
  if [[ $1 != 'movie' ]]; then
    if [[ -f missing_files.log ]]; then
      echo -e "${N}${R}[${FUNCNAME[0]}] ${G}\"${M}$Anime${G}\" extraction: DONE! ${N}  \b"
      echo -e "${N}${R}[${FUNCNAME[0]}] ${G}Make sure to check the missing files log inside ${C}$TMPDIR/genshiken-$USER/missing_files.log ${M}. ${N}  \b"
      [[ ! -z ${WAIT:-} && $WAIT -le 1 ]] && : || sleep 5
    else
      echo -e "\n${N}${R}[${FUNCNAME[0]}] ${G}Finished extracting all episodes for the ${M}${1//-*/}${G}: \"${M}$Anime${G}\" ${N}  \b"
    fi
  fi
}

# End:
# gfunc83000-download-anime.sh ends here
