# -*- shell-script -*-
# gfunc82000-anime-prompt.sh -- Prompt the user on which series they wish to see
# Copyright © 2015-2016 Michael Pagan
#
# Author: Michael Pagan
# E-Mail: michael.pagan@member.fsf.org
# Jabber: pegzmasta@member.fsf.org
#
# This file is part of Genshiken.
#
# Genshiken is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# Genshiken is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Genshiken. If not, see http://www.gnu.org/licenses/.
#===================================================================
function Anime_Prompt
{
  # Interact with the user to retrieve and view the series
  processing=1
  until [[ $processing = 0 ]]
  do Selection_IO $1

    # A series has been selected.  Now, determine how much anime is in that series.
    selected_series=$(cat selected_series_ 2> /dev/null)
    selected_series=${selected_series:-series_`sed 's_.*\[\(.\)|.*_\1_' < choice_`.txt}
    Total_Anime=$(wc -l < $selected_series)

    # Adjust the [Anime_Prompt] based on whether we're streaming or not
    [[ ! -z ${STREAM:-} ]] &&
    { local try=stream   opt_L=s opt_U=S opt='S=[S]tream'   desc_L=d desc_U=D desc='D=[D]escription'; } ||
    { local try=download opt_L=d opt_U=D opt='D=[D]ownload' desc_L=s desc_U=S desc='S=[S]ynopsis'   ; }
    UP="sed y/a${opt_L}${desc_L}qv/A${opt_U}${desc_U}QV/"

    # Read the users input and re-format it
    [[ -f anime_num_ ]] && input=$(eval $UP < anime_num_) || input=$(eval $UP < input_)

    # Flow control is dictated by the users' input.
    if [[ $(eval $UP <<< $REPLY) || $input != 'Q' ]]; then
      while [[ $processing -eq 1 ]]; do

        # Ensure we select the current users' input
        [[ -z ${input:-} ]] && { [[ ! -z ${REPLY:-} ]] && input=$(eval $UP <<< $REPLY) || input=$anime_num; }

        # [Q]uit (i.e. exit the script)
        [[ $input = 'Q' ]] && exit 0

        # The user chose to view [A]nother series.
        [[ $input = 'A' ]] && continue 3

        # [V]iew the list of anime again from 'first_title' to 'last_title'
        [[ $input = 'V' ]] && continue 2

        # Ensure the input obeys the following <<criteria>>: =================================================================================================\
        #                                                                                                                                                     |
        # o  Accepted_Letters are only valid when an anime has been selected                                                                                  |
        # o  Only valid characters (i.e. ADQSV, 0-9), and no mix matching between numbers and letters (only one or the other)                                 |
        # o  # of digits can't exceed the # of digits in Accepted_Letters/$Total_Anime; also, the numbers must fall within: 1-[total-#-of-anime-in-series]    |
        if [[ -n `tr -d [0-9] <<< $input | grep [A${opt_U}${desc_U}QV]` && -z ${Selected_Anime:-} ]] ||
           [[ -z ${input:-} || ! -z `grep [^A${opt_U}${desc_U}QV] <<< $input | grep '[^0-9]'` && -n `grep '[0-9]' <<< $input | grep '[^0-9]'` ]] ||
           [[ `expr $(grep [ADQSV] <<< $input | wc -m) '-' 1` -gt 1 ]] || [ ${#input} -gt ${#Total_Anime} -o $input -eq 0 -o $input -gt $Total_Anime ]
        then
          echo -e "${N}${R}[${FUNCNAME[0]}] ${A}${G}Wrong character; choose a number from ${M}1${G}-${M}$Total_Anime${G}! ${N}  \b"
          [[ ! -z ${WAIT:-} && $WAIT -le 1 ]] && : || sleep 2
          input=; continue 2
        else
          # Evaluate the first character of the argument's name; determine the name of the selected anime
          if [[ $selected_series = series_1.txt ]]
          then chr='^A-Z' lwr='.*'
          else chr=$(sed 's/.*_\(.\).*/\1/' <<< "$selected_series") lwr=$(tr '[:upper:]' '[:lower:]' <<< "$chr")
          fi; Selected_Anime=$((gawk -F">" '{ if (NR=='"${input#0}"') { print $2 }; }' | sed 's_<.*__') < $selected_series)

          # Inform the user what they selected, and prompt for a download/stream/other-options
          echo -e "\n${N}${R}[${FUNCNAME[0]}] ${G}You selected the Anime: \"${M}$Selected_Anime${G}\". ${N}  \b"
          echo -e "${N}${R}[${FUNCNAME[0]}] ${G}Would you like to ${M}$try${G} this, or view another series? ${N}"
          echo -en "${N}${R}[${FUNCNAME[0]}] ${G}A=[${M}A${G}]nother_Series; ${M}$opt${G}; ${M}$desc${G}; V=re[${M}V${G}]iew; Q=[${M}Q${G}]uit:${Y}   \b\b"
          read
          [[ $PAGE != less ]] && echo

          # Ensure the input contains no numbers (makes sense, if we're only looking for lettered options)
          [[ ! -z $(eval $UP <<< $REPLY | grep [^A${opt_U}${desc_U}QV]) ]] &&
          {
            echo -e "\n${N}${R}[${FUNCNAME[0]}] ${A}${G}Wrong character; enter one of the following: [A,${opt_U},${desc_U},V,Q] ${N}"
            [[ ! -z ${WAIT:-} && $WAIT -le 1 ]] && : || sleep 2
            continue
          }
          [[ $PAGE != less ]] && echo

          # The user chose to view the description for this series, in order to get a brief idea of what it's about.
          [[ $(eval $UP <<< $REPLY) = $desc_U ]] && anime_num=$(cat anime_num_ 2> /dev/null) anime_num=${anime_num:-`< input_`} &&
          { echo "$anime_num:[$chr|$lwr].*" > choice_; Download_Anime $2 --Describe; REPLY=; }

          # Terminate this function ($processing=0), and output the user's "anime of choice" to the filesystem
          [[ $(eval $UP <<< $REPLY) = $opt_U  ]] && anime_num=$(cat anime_num_ 2> /dev/null) anime_num=${anime_num:-`< input_`} &&
          { Clean_Up directory; echo "$anime_num:[$chr|$lwr].*" > choice_; processing=0; } || { echo; input=; }
        fi
      done
    else # the user chose to quit, right off the bat...
      exit 0
    fi
  done
}

# End:
# gfunc82000-anime-prompt.sh ends here
