# -*- shell-script -*-
# gfunc81000-series-prompt.sh -- Prompt the user on which series they want to select
# Copyright © 2015-2016 Michael Pagan
#
# Author: Michael Pagan
# E-Mail: michael.pagan@member.fsf.org
# Jabber: pegzmasta@member.fsf.org
#
# This file is part of Genshiken.
#
# Genshiken is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# Genshiken is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Genshiken. If not, see http://www.gnu.org/licenses/.
#===================================================================
function Series_Prompt
{
  # Display the list of series, and ask which to view
  processing=1
  until [[ $processing = 0 ]]
  do View_Series_List; echo
    echo -en "${N}${R}[${FUNCNAME[0]}] ${G}Enter the row number of the series you wish to select:${Y}   \b\b"; read
    [[ $PAGE != less ]] && echo; input=$(sed y/qv/QV/ <<< $REPLY)

    # There may be less than 27 categories, depending on whether or not any categories received no anime titles (like 'Q', for instance)
    total_series=$(ls -1 series_* | wc -l)

    # Flow control is dictated by the users' input.
    if [[ $input != 'Q' ]]; then
      while [[ $processing -eq 1 ]]; do

        # [Q]uit (i.e. exit the script)
        [[ $input = 'Q' ]] && exit 0

        # Ensure the input contains: Only valid characters (i.e. VQ, 0-9); finally, the input must fall within the range of 1-27 |
        # NOTE: Leading zeroes are removed with ${VAR#0}, and an input with more than 2 digits are rejected                      |
        [[ -z ${input:-} || ! -z `grep [^QV0-9] <<< $input || echo` ]] || [[ `expr $(grep [QV] <<< $input | wc -m) '-' 1` -gt 1 ]] ||
        [ ${#input} -gt 2 -o $input -eq 0 -o $input -ge $(expr $(echo $total_series) '+' 1) ] &&
        {
          echo -e "${N}${R}[${FUNCNAME[0]}] ${A}${G}Wrong character; choose a number from ${M}1${G}-${M}$total_series! ${N}"
          [[ ! -z ${WAIT:-} && $WAIT -le 1 ]] && : || sleep 2
          continue 2
        } ||
        { echo ${input#0} > selection_; echo; processing=0; }
      done
    else # the user chose to quit, right off the bat...
      exit 0
    fi
  done
}

# End:
# gfunc81000-series-prompt.sh ends here
