# -*- shell-script -*-
# gfunc1-hdmi-setup.sh -- Setup the HDMI Monitor for proper viewing
# Copyright © 2015-2016 Michael Pagan
#
# Author: Michael Pagan
# E-Mail: michael.pagan@member.fsf.org
# Jabber: pegzmasta@member.fsf.org
#
# This file is part of Genshiken.
#
# Genshiken is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# Genshiken is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Genshiken. If not, see http://www.gnu.org/licenses/.
#===================================================================
function HDMI_Setup
{
  # Determine if xrandr is a part of the GNU system
  XRAND=$([[ -z `which xrandr` ]] && echo || echo xrandr)

  if [[ ! -z ${XRAND:-} ]]; then
    export XRAND
    export SCR_LEFT=$(xrandr | grep '[ ]connected' | sed -n '1 s/.*/&/p' | sed 's/[ ].*//')
    SCR_LEFT_STAT=$(xrandr | sed -n "/$SCR_LEFT/,/[A-Z]/ p" | grep '*') # Signal On/Off?
    export MONITOR=$SCR_LEFT
    [[ -z ${SCR_LEFT_STAT:-} ]] &&
    {
      echo -e "\n${N}${R}[${FUNCNAME[0]}] ${B}$PROGNAME ${G}has detected \"${M}$SCR_LEFT${G}\", but it appears there's no signal.  Let's fix that ... ${N}"
      [[ ! -z ${WAIT:-} && $WAIT -le 1 ]] && : || sleep 2
      export SCR_RIGHT=$(xrandr | grep HDMI | grep '[ ]connected' | sed 's/[ ].*//')
      SCR_RIGHT_STAT=$(xrandr | sed -n "/$SCR_RIGHT/,/[A-Z]/ p" | grep '*')
      SCR_RIGHT_MODE=$(xrandr | sed -n "/$SCR_RIGHT/,/[A-Z]/ p" | grep + | sed -n '2 s_.*_&_p' | gawk '{ print $1}')

      # If the default monitor is off: Turn it on
      [ -n   "$SCR_RIGHT" -a -z "$SCR_RIGHT_STAT" ] && xrandr --output $SCR_RIGHT --auto
      [[ ! -z ${SCR_RIGHT:-} ]] &&                     xrandr --output $SCR_LEFT  --auto --output $SCR_RIGHT --right-of $SCR_LEFT ||
                                                       xrandr --output $SCR_LEFT  --auto
    }
  else
    unset XRAND
    return
  fi
  # Define the HDMI Monitor
  echo -e "\n${N}${R}[${FUNCNAME[0]}] ${G}If you have an HDMI Monitor: Connect it now, so that the video output can be sent to it. ${N}"
  echo -en "${N}${R}[${FUNCNAME[0]}] ${G}Press ${M}[ENTER] ${G}to continue ... ${N}"; read nothing; unset nothing; [[ $PAGE != less ]] && echo

  [[ ! -z ${WAIT:-} && $WAIT -le 1 ]] && : || sleep 2
  SCR_RIGHT=$(xrandr | grep HDMI | grep '[ ]connected' | sed 's/[ ].*//') # Connected? ...

  # If the HDMI Monitors' signal is off: Turn it on
  [[ ! -z ${SCR_RIGHT:-} ]] && SCR_RIGHT_STAT=$(xrandr | sed -n "/$SCR_RIGHT/,/[A-Z]/ p" | grep +) &&
  {
    # Define the HDMI mode as either the best resolution or the highest
    LCD_REGEX=$(xrandr | sed -n "/$SCR_LEFT/,/[A-Z]/ p" | grep '*' | gawk '{ print $1 }' | sed -e 's_.x_\.x_' -e 's_.$_\._')
    BEST_RES=$(xrandr | sed -n "/$SCR_RIGHT/,/[A-Z]/ p" | gawk '{ print $1 }' | grep "$LCD_REGEX") # Matches Monitor
    HIGH_RES=$(xrandr | sed -n "/$SCR_RIGHT/,/[A-Z]/ p" | grep + | gawk '{ print $1}')             # Maximum Ratio
    [[ -z ${BEST_RES:-} ]] && SCR_RIGHT_MODE="$HIGH_RES" || SCR_RIGHT_MODE="$BEST_RES"
    [[ ! -z ${SCR_RIGHT_STAT:-} ]] &&
    {
      echo -e "\n${N}${R}[${FUNCNAME[0]}] ${B}$PROGNAME ${G}detected \"${M}$SCR_RIGHT${G}\" ... ${N}"
      echo -e "${N}${R}[${FUNCNAME[0]}] ${G}A resolution of \"${M}$SCR_RIGHT_MODE${G}\" will be set ...\n ${N}"
      [[ ! -z ${WAIT:-} && $WAIT -le 1 ]] && : || sleep 5
    } ||
    {
      echo -e "\n${N}${R}[${FUNCNAME[0]}] ${B}$PROGNAME ${G}has detected \"${M}$SCR_RIGHT${G}\", but it appears there's no signal.  Let's fix that ... ${N}"
      [[ ! -z ${WAIT:-} && $WAIT -le 1 ]] && : || sleep 2
      xrandr --output $SCR_RIGHT --auto; echo -e "${N}${R}[${FUNCNAME[0]}] ${G}A resolution of \"${M}$SCR_RIGHT_MODE${G}\" will be set ...\n ${N}"
      [[ ! -z ${WAIT:-} && $WAIT -le 1 ]] && : || sleep 3
    }
    # Let the user know how to restore the Default Monitor; afterwords, activate HDMI Monitor upon request
    echo "${N}${R}[${FUNCNAME[0]}] ${G}DO NOT TERMINATE THIS COMMAND-LINE SESSION!  ${B}$PROGNAME ${G}MUST restore your default settings first. ${N}"
    echo "${N}${R}[${FUNCNAME[0]}] ${B}$PROGNAME ${G}will return your default monitor, after every video in \"${M}$DIR_TITLE${G}\" has been played. ${N}"
    echo "${N}${R}[${FUNCNAME[0]}] ${G}To stop playing videos from \"${M}$SCR_RIGHT${G}\": enter this on the active console: ${M}C-c ${N}"
    echo -e "${N}${R}[${FUNCNAME[0]}] ${G}Afterwords, to reset the monitor, simply restart \"${B}$PROGNAME ${G}\" by pressing: ${M}C-c C-p C-j ${N}"
    echo -n "${N}${R}[${FUNCNAME[0]}] ${G}Would you like to setup your HDMI Monitor for video output? (Y/*): ${Y}"; read; [[ $PAGE != less ]] && echo
    case $(sed 'y/y/Y/' <<< $REPLY) in
      Y)
         echo -e "\n${N}${R}[${FUNCNAME[0]}] ${G}Switching Default Monitor (${M}$SCR_LEFT${G}): ${N}${R}OFF ${N}"
         echo -e "[${FUNCNAME[0]}] ${G}Switching HDMI Monitor (${M}$SCR_RIGHT) as: ${N}${R}ACTIVE ${N}"; [[ ! -z ${WAIT:-} && $WAIT -le 1 ]] && : || sleep 2
         xrandr --output $SCR_LEFT --off --output $SCR_RIGHT --mode $SCR_RIGHT_MODE; MONITOR=$SCR_RIGHT
         [[ ! -z ${WAIT:-} && $WAIT -le 1 ]] && : || sleep 10; clear 2> /dev/null
      ;;
      *)
         clear 2> /dev/null
      ;;
    esac
  }
}

# End:
# gfunc1-hdmi-setup.sh ends here
