# -*- shell-script -*-
# func2-restore-monitor.sh -- Turn the computer monitor back on
# Copyright © 2015-2016 Michael Pagan
#
# Author: Michael Pagan
# E-Mail: michael.pagan@member.fsf.org
# Jabber: pegzmasta@member.fsf.org
#
# This file is part of Genshiken.
#
# Genshiken is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# Genshiken is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Genshiken. If not, see http://www.gnu.org/licenses/.
#===================================================================
function Restore_Monitor
{
  # Restore the default Monitor settings
  if [[ -n ${MONITOR:-} ]]; then
    [[ $MONITOR = $SCR_RIGHT && ! -z ${XRAND:-} ]] &&
    {
      xrandr --output $SCR_LEFT --auto --output $SCR_RIGHT --right-of $SCR_LEFT
      [[ ! -z ${WAIT:-} && $WAIT -le 1 ]] && : || sleep 3
    }
  fi
}

# End:
# func2-restore-monitor.sh ends here
