# -*- shell-script -*-
# func1-early-termination.sh -- If the SIGINT signal was sent (C-c) in the process of downloading/streaming/viewing an anime, then save before exitting
# Copyright © 2015-2016 Michael Pagan
#
# Author: Michael Pagan
# E-Mail: michael.pagan@member.fsf.org
# Jabber: pegzmasta@member.fsf.org
#
# This file is part of Genshiken.
#
# Genshiken is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# Genshiken is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Genshiken. If not, see http://www.gnu.org/licenses/.
#===================================================================
function Early_Termination
{
  # If the user is currently running a stream in the background: Kill it!
  if [[ `ps aux | grep "$PLAYER"` ]]; then
    VIDEO_PID=$(ps aux | grep "$PLAYER" | grep -v 'grep' | gawk '{ print $2 }')
    [[ -n ${VIDEO_PID:-} ]] && kill -15 $VIDEO_PID
  fi
  # Remove the stream log if it exists
  [[ -f ${STREAM_LOG:-} ]] && rm $STREAM_LOG

  #  If the user interrupted genshiken during its [Extract_Series_List] procedure, then ensure we clean-up the 'details' directory |
  #                                                                                                                                |
  #  NOTE: We need to clean-up here; otherwise, the [Extract_Series_List] procedure will create a                                  |
  #+ 'diff' file called 'new_releases.log'.  Whatever files that genshiken was interrupted from downloading                        |
  #+ the last time it was run, will mistakenly be considered as a new release.  See the function, [Update_Previous_Sessions],      |
  #+ to learn why that is bad. ====================================================================================================/
  if [[ -f $DIR_DET/.extraction_interrupted ]]; then
    last_anime_type=`< $DIR_DET/.extraction_interrupted`
    rm $DIR_DET/.extraction_interrupted
    [[ -f $DIR_DET/$last_anime_type/$page_path-list ]] && rm $DIR_DET/$last_anime_type/*
  fi
  # Lets remove any temporary input files
  last_anime_type=`< $DIR_DET/../.last_anime_type`
  cd $DIR_DET/$last_anime_type/
  [[ ! -z `ls -la | grep '.*_$' | gawk '{ print $9 }'` ]] && ls -la | grep '.*_$' | gawk '{ print $9 }' | xargs rm

  # Exit if no choices have been made in this current session, or if there is no session file for this active session
  [[ ! -f $DIR_DET/../last_choice.log ]] && echo -e \\r && exit 0
  [[ ! `find $DIR_DET/../ -name "previous-session-${MAIN//-/}-${$}-*" -type f -print` ]] && echo -e \\r && exit 0

  # It's safe to delete this file now
  rm $DIR_DET/../last_choice.log

  # Remove any backup restore files
  find $DIR_DET/../ -name *.backup -exec rm {} +

  # Let's save the user's current session
  if [[ -z ${NO_SESSIONS:-} ]]; then

    # Let's inform the user what we'll do before we exit
    echo -e "\n${N}${R}[${FUNCNAME[0]}] ${B}$PROGNAME ${G}is updating ${M}${USER^?}\`s ${G}current session file ... ${N}  \b"
    [[ ! -z ${WAIT:-} && $WAIT -le 1 ]] && : || sleep 2

    #  If a session file, with the same session type (get/stream) as the active genshiken process, exists; |
    #+ and, if it contains the same name as the currently selected anime: Remove it                        |
    [[ ! -z ${title:-} ]] &&
    {
      if [[ `find $DIR_DET/../ -name "previous-session-${MAIN//-/}-*" -type f -exec grep "$title" {} + |\
             grep -v $$ | gawk -F: '{ print $2 }' | sed -n '1 p'` = $title ]]
      then
        [[ $episode = 0 ]] && episode=1
        echo -e "${N}${R}[${FUNCNAME[0]}] ${G}A duplicate session with a selected anime of \"${M}$title${G}\" already exists! ${N} \b"
        [[ ! -z ${WAIT:-} && $WAIT -le 1 ]] && : || sleep 1
        echo -e "${N}${R}[${FUNCNAME[0]}] ${G}Replacing your old session with your new one ... ${N} \b"
        find $DIR_DET/../ -name "previous-session-${MAIN//-/}-*" -type f -print | xargs grep "$title" | grep -v $$ | gawk -F: '{ print $1 }' | xargs rm
      fi
    }
    #  If a session file, with the same session type (view) as the active genshiken process, exists; |
    #+ and, if it contains the same name as the currently selected anime: Remove it                  |
    [[ ! -z ${DIR_TITLE:-} ]] &&
    {
      if [[ `find $DIR_DET/../ -name "previous-session-${MAIN//-/}-*" -type f -exec grep "$DIR_TITLE" {} + |\
             grep -v $$ | gawk -F: '{ print $2 }' | sed -n '1 p'` = $DIR_TITLE ]]
      then
        [[ $episode = 0 ]] && episode=1
        echo -e "${N}${R}[${FUNCNAME[0]}] ${G}A duplicate session with a selected anime of \"${M}$DIR_TITLE${G}\" already exists! ${N} \b"
        [[ ! -z ${WAIT:-} && $WAIT -le 1 ]] && : || sleep 1
        echo -e "${N}${R}[${FUNCNAME[0]}] ${G}Replacing your old session with your new one ... ${N} \b"
        find $DIR_DET/../ -name "previous-session-${MAIN//-/}-*" -type f -print | xargs grep "$DIR_TITLE" | grep -v $$ | gawk -F: '{ print $1 }' | xargs rm
      fi
    }
    # Let's update the user's session file with their selected anime of choice (that Genshiken will understand)         |
    # NOTE: The '--view' Option is excluded, because it will have already been updated by now (i.e. it's 1 Menu vs. 27) |
    if [[ $MAIN != '--view' ]]
    then sed -i "s/\(^[0-9]*:.*\)/$episode_count+\1/" $DIR_DET/../previous-session-${MAIN//-/}-${$}-$RAND.log
    fi
    # The last thing to add to the user's session file, is what type of anime they chose
    echo `< $DIR_DET/../.last_anime_type` >> $DIR_DET/../previous-session-${MAIN//-/}-${$}-$RAND.log

    # This next value is only added when overriding the default decision to ignore non-special episodes from an Anime-Type of 'ova'
    [[ ! -z ${OVERRIDE:-} ]] && echo $OVERRIDE >> $DIR_DET/../previous-session-${MAIN//-/}-${$}-$RAND.log

    # Housekeeping
    echo -e "${N}${R}[${FUNCNAME[0]}] ${G}Cleaning up temporary files ... ${N}  \b"
    [[ ! -z ${WAIT:-} && $WAIT -le 1 ]] && : || sleep 2
    cd $DIR_ANIM/$last_anime_type && Clean_Up hierarchy; cd - 1> /dev/null
    echo -e "${N}${R}[${FUNCNAME[0]}] ${G}Your \"${M}${MAIN//-/}${G}\" session has been saved! ${N}  \b"; exit 20 # EARLY TERMINATION CODE ...
  else

    # The user does not want Genshiken to save their current session
    rm $DIR_DET/../previous-session-${MAIN//-/}-${$}-$RAND.log
  fi
  # Restore the original computer display, if not already
  Restore_Monitor
}

# End:
# func1-early-termination.sh ends here
