// $Id: threadqueue.cpp,v 1.6 2006/09/21 18:20:53 khlut Exp $
// Copyright 2005 Elphel, Inc.
//
// This file is part of GenReS.
//
//    GenReS is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    GenReS is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with GenReS; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#include "nsCOMPtr.h"
#include "nsIServiceManagerUtils.h"
#include "nsIEventQueueService.h"
#include "nsIEventQueue.h"
#include <stdio.h>

static NS_DEFINE_CID( kEventQueueService, NS_EVENTQUEUESERVICE_CID );

extern "C" void PR_CALLBACK DestroyEvent(PLEvent* event) ;                                                                                   
extern "C" void * PR_CALLBACK HandleEvent(PLEvent* event) ;

nsIServiceManager * SM = 0;

extern "C" void init_qservice(nsISupports *nss)
{

    if(!nss)	return;

    nss->QueryInterface(NS_GET_IID(nsIServiceManager), (void**)&SM);
    NS_RELEASE(nss);

    if(!SM) {
        printf("Unable to get service manager!\n");	return;
    }

}
extern "C" void shut_qservice()
{
    NS_IF_RELEASE(SM);
    return;
}
static nsIEventQueue * GetEventQ(PRThread *receiver)
{
    nsIEventQueue *eventQ=0;
    nsIEventQueueService * eventQService=0;
  if(!SM)return eventQ;    
    SM->GetService(kEventQueueService, NS_GET_IID(nsIEventQueueService), (void **)&eventQService);
  if(!eventQService)return eventQ;
    eventQService->GetThreadEventQueue(receiver,&eventQ);
    NS_IF_RELEASE(eventQService);
  return eventQ;
}


extern "C" bool post_event_to_thread( PRThread *receiver, PLEvent *(*allocator)(void * owner, const void * msg), 
void * owner, const void * msg )
{
    bool r=true;
    PLEvent * event;

    nsIEventQueue *eventQ=GetEventQ(receiver);
    if(!eventQ) { printf("Unable to get thread queue!\n");	return false;}

    eventQ->EnterMonitor();
    if((event=(*allocator)(owner, msg)))
      if(NS_FAILED( eventQ->PostEvent(event) )) {
	PL_DestroyEvent(event);
	r=false;
      }
    eventQ->ExitMonitor();

    NS_IF_RELEASE(eventQ);
    return r;
}

extern "C" void ProcessOwnerEvents(PLEvent* event, void* data, PLEventQueue* queue) {
//    if(event->owner == data) {
	PL_DequeueEvent(event, queue);
	PL_HandleEvent(event);
//    }
}

extern "C" bool process_pending_events(void *owner)
{
    // Get the event queue of the current thread...

    nsIEventQueue *eventQ=GetEventQ(PR_GetCurrentThread());
    if(!eventQ) { printf("Unable to get thread queue!\n");	return false;}
    PLEventQueue *PLEQ=0;
    eventQ->GetPLEventQueue(&PLEQ);

    if(!PLEQ) { NS_IF_RELEASE(eventQ); printf("Unable to get PLEventQueue!\n"); return false; }

    eventQ->EnterMonitor();
    PL_MapEvents(PLEQ,&ProcessOwnerEvents, owner);
    eventQ->ExitMonitor();
    
    NS_IF_RELEASE(eventQ);
    return true;
}
