// $Id: genres.h,v 1.8 2006/04/24 20:00:20 khlut Exp $
// Copyright 2005 Elphel, Inc.
//
// This file is part of GenReS.
//
//    GenReS is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    GenReS is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with GenReS; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#include <npapi.h>
#include <npupp.h>
#include <stdio.h>
#include <string.h>
#include <prmem.h>
#include <prthread.h>
#include <plevent.h>
#if (NP_VERSION_MAJOR==0)&&(NP_VERSION_MINOR<14)
#error "Version of the Mozilla development files is too old. Firefox 1.0 or Mozilla 1.7.5 or newer is necessary."
#endif

// Plugin functions for function table

NPError NPP_New(NPMIMEType pluginType, NPP instance, uint16 mode, int16 argc, char* argn[], char* argv[], NPSavedData* saved);
NPError NPP_Destroy(NPP instance, NPSavedData** save);
NPError NPP_SetWindow(NPP instance, NPWindow* pNPWindow);
NPError NPP_GetValue(NPP instance, NPPVariable variable, void *value);
NPError NPP_SetValue(NPP instance, NPNVariable variable, void *value);
NPError NPP_NewStream(NPP instance, NPMIMEType type, NPStream* stream, NPBool seekable, uint16* stype);
NPError NPP_DestroyStream(NPP instance, NPStream *stream, NPError reason);
void    NPP_StreamAsFile(NPP instance, NPStream* stream, const char* fname);
int32   NPP_WriteReady(NPP instance, NPStream *stream);
int32   NPP_Write(NPP instance, NPStream *stream, int32 offset, int32 len, void *buffer);
void    NPP_Print(NPP instance, NPPrint* printInfo);
void    NPP_URLNotify(NPP instance, const char* url, NPReason reason, void* notifyData);
int16   NPP_HandleEvent(NPP instance, void* event);

// Storage functions

typedef struct {
    NPIdentifier key;
    NPVariant value;
} st_var;

typedef struct {
    int size;
    bool sorted;
    st_var var[0];
} storage;

storage * storage_new();
bool storage_add(storage **stor, NPIdentifier key, const NPVariant *value);
bool storage_set(storage **stor, NPIdentifier key, const NPVariant *value);
NPVariant * storage_get(storage *stor, NPIdentifier key);
void storage_free(storage *stor);
bool NPVariant_cpy(NPVariant *to, const NPVariant *from);

// Plugin instance data

typedef struct {
  PRThread *browser, *observer;
  pid_t slave;
  FILE *slavectrl;
  int stream;
  NPStream *npstream;
  Window xid;
  char *mime;
  storage *vars;
  volatile int refcnt;
  PRLock* lock;
  NPP instance;
  enum {Init, Running, Cancelling} status;
} PD;

// Private functions

void PR_CALLBACK observer_thread( PD* );
PLEvent * strevent(PD * pd, const char * str);
bool post_event_to_thread( PRThread *receiver, PLEvent *(*allocator)(PD * pd, const char * str), PD * pd, const char * str );
bool process_pending_events(void *owner);
int run_slave( PD * pd, char *mime, int restart );
char *get_mime_list();
char *find_slave(char *mime);
void wait_slave(PD * pd);
void init_qservice(void*);
void shut_qservice();
char *strpath(char *_path);
char *pair(char **s, const char *spaces, const char *delims, const char *eols);
void configure();

extern int debug, mozillastreams;
#define Debug debug&&printf
