// $Id: observer_thread.c,v 1.5 2006/03/22 21:02:09 khlut Exp $
// Copyright 2005 Elphel, Inc.
//
// This file is part of GenReS.
//
//    GenReS is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    GenReS is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with GenReS; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#include "genres.h"
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <errno.h>

int run_slave( PD * pd, char * mime, int restart ) // this function is not in observer thread, it run a separate parallel process
{
    int p[2]={-1,-1};
    char *path = find_slave(mime);
    
    if(socketpair(AF_UNIX, SOCK_STREAM, 0, p)) perror("socketpair");
    fflush(stdout);
    pd->slave=fork();
    if(!pd->slave) { // new process branch
	close(p[0]);
	dup2(p[1],0);
	dup2(p[1],1);
	dup2(p[1],2);
	close(p[1]);
	if(restart) execl(path,path,"--no-vars",0);
	else execl(path,path,0);
	perror("error");
	Debug("errorfile=%s\n",path);
	Debug("run=0\n");	
	_exit(1);
    }
    if(pd->slave==-1) return 1;
    close(p[1]);
    pd->slavectrl=fdopen(p[0],"w");
    setlinebuf(pd->slavectrl);
    return 0;
}

void PR_CALLBACK observer_thread( PD * pd )
{
    int i;
    char buf[256];
    FILE *slaveout=fdopen(fileno(pd->slavectrl),"r");
    Debug("Observer1\n");
    setlinebuf(slaveout);
    
    post_event_to_thread( pd->browser, strevent, pd, "ready=1" );
    Debug("Observer2\n");
    while(1) {
	errno=0;
	if(!fgets(buf,256,slaveout)) break;
	i=strlen(buf);
        if(buf[--i]=='\n')  buf[i]=0;
	if(!i)		continue;
	while(pd->refcnt>30 && pd->status!=Cancelling) {PR_Sleep(100); Debug("%p wait main thread\n",pd); continue;}
	while(pd->status!=Cancelling && !post_event_to_thread( pd->browser, strevent, pd, buf )) PR_Sleep(100);
    } 
    PR_Lock(pd->lock);
     fclose(slaveout);
     fclose(pd->slavectrl);
     pd->slavectrl=0;
    PR_Unlock(pd->lock);
    post_event_to_thread( pd->browser, strevent, pd, "run=0" );    
    post_event_to_thread( pd->browser, strevent, pd, "ready=0" );
}
