// $Id: storage.c,v 1.1.1.1 2005/11/04 09:07:01 khlut Exp $
// Copyright 2005 Elphel, Inc.
//
// This file is part of GenReS.
//
//    GenReS is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    GenReS is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with GenReS; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#include "genres.h"
/*
typedef struct {
    NPIdentifier key;
    NPVariant value;
} st_var;

typedef struct {
    int size;
    st_var var[0];
} storage;
*/

extern NPNetscapeFuncs NPN;

static int mycompare(const void*a,const void*b)
{
    return (char*)((st_var*)a)->key - (char*)((st_var*)b)->key;
}
storage * storage_new()
{
    storage *m=malloc(sizeof(storage));
    if(m) m->size=0;
    return m;
}
bool storage_add(storage **stor, NPIdentifier key, const NPVariant *value)
{
    storage *ns;
    ns=realloc(*stor, sizeof(storage) + ((*stor)->size+1)*sizeof(st_var));
    if(!ns) return false;
    *stor=ns;
    ns->sorted=false;
    if( !NPVariant_cpy( &(ns->var[ns->size].value), value ) ) return false;
    ns->var[ns->size].key=key;
    ns->size++;
    return true;
}
NPVariant * storage_get(storage *stor, NPIdentifier key)
{
    st_var *found;
    if(!stor->size) return 0;
    if(!stor->sorted) {
	qsort(stor->var, stor->size, sizeof(st_var), &mycompare);
	stor->sorted=true;
    }
    st_var el={key,};
    found=bsearch(&el,stor->var, stor->size, sizeof(st_var), &mycompare);
    if(!found) return 0;
    return &(found->value);
}
void storage_free(storage * stor){
    int i;
    if(!stor)	return;
    for(i=0;i<stor->size;i++) NPN.releasevariantvalue(&(stor->var[i].value));
    free(stor);
}
bool NPVariant_cpy( NPVariant *to, const NPVariant *from)
{
    *to=*from;
    switch(to->type) {
	case NPVariantType_String:
	    if(!( to->value.stringValue.utf8characters=PR_Malloc(from->value.stringValue.utf8length) )) {
		to->type=NPVariantType_Void;
		return false;
    	    }
	    strncpy(to->value.stringValue.utf8characters,
		from->value.stringValue.utf8characters,
		from->value.stringValue.utf8length);
	    break;
 	case NPVariantType_Object:
	    to->value.objectValue=NPN.retainobject(from->value.objectValue);
	    break;
	default:
	    break;
    }
    return true;
}
bool storage_set(storage **stor, NPIdentifier name, const NPVariant *value)
{
    NPVariant *var=storage_get(*stor, name);
    if(var) {
	return NPVariant_cpy(var, value);	
    }else{
	return storage_add( stor, name, value );
    }
}
