// Copyright 2005 Elphel, Inc.
//
// This file is part of GenReS.
//
//    GenReS is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    GenReS is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with GenReS; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#include "genres.h"
#include <dirent.h>
#include <sys/stat.h>
#include <unistd.h>

/*
** Slave scripts may be located in $HOME/.mozilla/genres/slaves or /etc/genres/slaves
** names are mime types
*/

static char *slavedirs[] = { "/usr/lib/genres/slaves/", "~/.mozilla/genres/slaves/" };
static char *mimelist=0;

#define PSIZE 1024
/* recursive dir listing */

int listdir(char **list, int *listlen,
 char **path,	// ptr to full path to current dir with trailed '/'
 int pathlen, 	// length of start path with trailed '/'
 int subdirlen, // length of current subdir name concatenated with start path (is 0 for start dir)
 int maxlevel)
{
    DIR *dir;
    struct dirent *de;
    struct stat st;
    int listmax= (*listlen+PSIZE) & ~(PSIZE-1);
    
    *path=realloc(*path, pathlen+subdirlen+NAME_MAX+2);	if(!*path){perror("realloc"); return -1;}
    (*path)[pathlen+subdirlen]=0;
    dir = opendir(*path);	if(!dir) { perror(*path); return 0; }
    while(( de=readdir(dir) )) {
	int namelen=strlen(de->d_name);
	if( de->d_name[0]<'a' || de->d_name[0]>'z' )	continue;
	strcpy(*path+pathlen+subdirlen, de->d_name);
	if( stat(*path,&st)<0 )		{ perror(*path); continue; }
	if( S_ISDIR(st.st_mode) ) {
	    if( !maxlevel ) 	continue;
	    (*path)[pathlen+subdirlen+namelen]='/';
	    if(listdir(list, listlen, path, pathlen, subdirlen+namelen+1, maxlevel-1))	break;
	}else if( access(*path,X_OK)==0 ){
	    if(strstr(*list,*path+pathlen)) continue;
	    if(*listlen+subdirlen+namelen+4 > listmax) {
		listmax= (*listlen+subdirlen+namelen+3+PSIZE) & ~(PSIZE-1);
		*list=realloc(*list, listmax);	if(!*list) {perror("realloc"); break;}
	    }
	    strcpy(*list+*listlen, *path+pathlen);
	    *listlen+=subdirlen+namelen;
	    strcpy(*list+*listlen, "::;");
	    *listlen+=3;
	}
    }
    closedir(dir);
    if(*path && *list)  return 0;
    return -1;
}

// duplicate string, subsitute $HOME if need, and reserv NAME_MAX bytes at end of string for filename
char *strpath(char *_path)
{
    char * path;

    if(_path[0]=='~') {
	char *home=getenv("HOME");	if(!home) return 0;
	path=malloc(strlen(_path)+strlen(home)+NAME_MAX);	if(!path) return 0;
        strcpy(path, home);
	strcat(path, _path+1);
    }
    else {
	path=malloc(strlen(_path)+NAME_MAX+1);	if(!path) return 0;
        strcpy(path, _path);
    }
    return path;
}

char *get_mime_list()
{
    char *path=0;
    int listlen=0,	i;

    if(!mimelist) mimelist=malloc(PSIZE);	if(!mimelist) return mimelist;
    mimelist[0]=0;
    for(i=sizeof slavedirs/sizeof slavedirs[0]; i-- ;) {
	if(path)free(path);
	path=strpath(slavedirs[i]);	if(!path) continue;
	if(listdir(&mimelist,&listlen,&path,strlen(path),0, 1))	break;
    }
    if(path)free(path);
    return mimelist;    
}

char *find_slave(char *mime)
{
    char *path=0;
    int	i;

    for(i=sizeof slavedirs/sizeof slavedirs[0]; i-- ;) {
	if(path)free(path);
	path=strpath(slavedirs[i]);	if(!path) continue;
	strncat(path,mime,NAME_MAX);
	if( access(path,X_OK)==0 )	return path;
    }
    return 0;
}
