/*
Copyright 2013 Cameron Palmer

This file is a part of Genezip.

Genezip is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Genezip is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTIBILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Genezip.  If not, see <http://www.gnu.org/licenses/>
*/

/*!
  \file snp.h
  \brief wrapper for GWAS marker metadata
 */


#include "genezip/snp.h"

unsigned genezip_utils::snp::chromosome_numeric(const std::string &s) const {
  if (!s.compare("X")) {
    return 23;
  } else if (!s.compare("Y")) {
    return 24;
  } else if (!s.compare("XY")) {
    return 25;
  } else if (!s.compare("M")) {
    return 26;
  } else {
    try {
      return genezip_utils::from_string<unsigned>(s);
    } catch (const std::domain_error &e) {
      throw std::domain_error("snp::chromosome_numeric: unrecognized "
			      "chromosome code: \"" + s + "\"");
    }
  }
}
const std::string &genezip_utils::snp::allele_n(unsigned index) const {
  if (!index)
    throw std::domain_error("snp::allele_n: alleles are indexed on [1,n],"
			    "not [0,n)");
  if (index > _alleles.size())
    throw std::domain_error("snp::allele_n: index invalid: " +
			    genezip_utils::to_string<unsigned>(index));
  return _alleles.at(index - 1);
}
void genezip_utils::snp::allele_n(const std::string &allele,
				  unsigned           index) {
  if (!index)
    throw std::domain_error("snp::allele_n: alleles are indexed on [1,n],"
			    "not [0,n)");
  if (index > _alleles.size())
    _alleles.resize(index, "");
  _alleles.at(index - 1) = allele;
}
