/*
Copyright 2013 Cameron Palmer

This file is a part of Genezip.

Genezip is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Genezip is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTIBILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Genezip.  If not, see <http://www.gnu.org/licenses/>
*/

/*!
  \file individual.h
 */
#ifndef __GENEZIP__INDIVIDUAL_H__
#define __GENEZIP__INDIVIDUAL_H__

#include <string>

namespace genezip_utils {
  //! a class for sample ID metadata
  class individual {
  public:
    //! default constructor
    individual() {}
    //! copy constructor
    individual(const individual &obj)
      : _fid(obj._fid),
      _iid(obj._iid),
      _pat(obj._pat),
      _mat(obj._mat),
      _sex(obj._sex),
      _phenotype(obj._phenotype),
      _missingness(obj._missingness) {}
    //! destructor
    ~individual() throw() {}
    // //////////////ACCESSORS////////////////////
    //! get the sample's family id
    //! \return the sample's family id
    const std::string &fid() const {return _fid;}
    //! set the sample's family id
    //! \param s the new family id for the sample
    void fid(const std::string &s) {_fid = s;}
    //! get the sample's individual id
    //! \return the sample's individual id
    const std::string &iid() const {return _iid;}
    //! set the sample's individual id
    //! \param s the new individual id for the sample
    void iid(const std::string &s) {_iid = s;}
    //! get the sample's paternal id
    //! \return the sample's paternal id
    const std::string &pat() const {return _pat;}
    //! set the sample's paternal id
    //! \param s the new paternal id for the sample
    void pat(const std::string &s) {_pat = s;}
    //! get the sample's maternal id
    //! \return the sample's maternal id
    const std::string &mat() const {return _mat;}
    //! set the sample's maternal id
    //! \param s the new maternal id for the sample
    void mat(const std::string &s) {_mat = s;}
    //! get the sample's sex code
    //! \return the sample's sex code
    const std::string &sex() const {return _sex;}
    //! set the sample's sex code
    //! \param s the new sex code for the sample
    void sex(const std::string &s) {_sex = s;}
    //! get the sample's phenotype
    //! \return the sample's phenotype
    const std::string &phenotype() const {return _phenotype;}
    //! set the sample's phenotype
    //! \param s the new phenotype for the sample
    void phenotype(const std::string &s) {_phenotype = s;}
    //! get the sample's missingness rate
    //! \return the sample's missingness rate
    double missingness() const {return _missingness;}
    //! set the sample's missingness rate
    //! \param d the new missingness rate for the sample
    void missingness(const double &d) {_missingness = d;}
  private:
    std::string _fid;//!< family ID
    std::string _iid;//!< individual ID
    std::string _pat;//!< paternal ID
    std::string _mat;//!< maternal ID
    std::string _sex;//!< sex code
    std::string _phenotype;//!< phenotype
    double _missingness;//!< per-sample missingness rate
  };
}

#endif //__INDIVIDUAL_H__
