/*
Copyright 2013 Cameron Palmer

This file is a part of Genezip.

Genezip is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Genezip is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTIBILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Genezip.  If not, see <http://www.gnu.org/licenses/>
*/

/*!
  \file gzfile_decompress.h
  \brief decompress a gzipped bit vector
 */
#ifndef __GENEZIP__GZFILE_DECOMPRESS_H__
#define __GENEZIP__GZFILE_DECOMPRESS_H__
#include <string>
#include <stdexcept>
#include "genezip/binary_buffer.h"
#include "genezip/gzfile_block_data.h"
#include "genezip/helper_functions.h"
#include "genezip/output_buffer.h"
#include "genezip/prob_vector.h"
namespace genezip_utils {
  /*!
    \class gzfile_decompress
    \brief decompress a gzipped bit vector
  */
  class gzfile_decompress {
  public:
    /*!
      \brief constructor
    */
    gzfile_decompress() {}
    /*!
      \brief destructor
    */
    ~gzfile_decompress() throw() {}
    /*!
      \brief decompress a gzipped bit stream and write it to vector
      @param intermediate_data_holder gzipped bit stream
      @param litlen_code huffman code to use on literals and match lengths
      @param distance_code huffman code to use on match offsets
      @param target destination vector for decompressed data
      @param expected_size expected number of extracted literals
    */
    void decompress_to_vector(const std::vector<bool> &
			      intermediate_data_holder,
			      const huffman_code &litlen_code,
			      const huffman_code &distance_code,
			      prob_vector &target,
			      unsigned expected_size);

  private:
  };
}
#endif //__GZFILE_DECOMPRESS_H__
