/*
Copyright 2013 Cameron Palmer

This file is a part of Genezip.

Genezip is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Genezip is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTIBILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Genezip.  If not, see <http://www.gnu.org/licenses/>
*/

#include "genezip/gzfile_decompress.h"

void genezip_utils::gzfile_decompress::decompress_to_vector(const std::vector<bool> &intermediate_data_holder,
							    const huffman_code      &litlen_code,
							    const huffman_code      &distance_code,
							    prob_vector             &target,
							    unsigned expected_size) {
  binary_buffer buffer(intermediate_data_holder);
  target.clear();
  
  //WITH HEADER PARSED, READ ALL THE BLOCKS IN THE LAND
  output_buffer obuffer(&target, expected_size);
  //obuffer.set_stream(&target);
  
  //we want to periodically recycle the buffer
  gzfile_block_data block;
  block.parse_vector(buffer, litlen_code, distance_code, obuffer);
}
